﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerDataAccountBaisc : IPerData
    {
        /// <summary>
        /// 行号
        /// </summary>
        public int RowNumber { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        #region EXCEL读取

        /// <summary>
        /// 核算单元类别 1 医生组 2护理组 3医技组
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string EmployeeName { get; set; }

        ///// <summary>
        ///// 科室名称
        ///// </summary>
        //public string Department { get; set; }

        /// <summary>
        /// 效率绩效人数
        /// </summary>
        public decimal PermanentStaff { get; set; }

        ///// <summary>
        ///// 科主任/护士长数量
        ///// </summary>
        //public decimal ManagerNumber { get; set; }

        /// <summary>
        /// 核算单元医生数量
        /// </summary>
        public decimal Number { get; set; }

        /// <summary>
        /// 预算比例
        /// </summary>
        public decimal BasicFactor { get; set; }

        ///// <summary>
        ///// 倾斜系数
        ///// </summary>
        //public decimal SlopeFactor { get; set; }

        ///// <summary>
        ///// 其他绩效1
        ///// </summary>
        //public decimal OtherPerfor1 { get; set; }

        /// <summary>
        /// 考核前其他绩效
        /// </summary>
        public Nullable<decimal> AssessBeforeOtherFee { get; set; }

        ///// <summary>
        ///// 其他绩效2
        ///// </summary>
        //public decimal OtherPerfor2 { get; set; }

        /// <summary>
        /// 药占比奖罚
        /// </summary>
        public decimal? MedicineExtra { get; set; }

        /// <summary>
        /// 材料占比奖罚
        /// </summary>
        public decimal? MaterialsExtra { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Extra { get; set; }

        /// <summary>
        /// 考核对分率
        /// </summary>
        public Nullable<decimal> ScoringAverage { get; set; }

        /// <summary>
        /// 考核后管理绩效
        /// </summary>
        public Nullable<decimal> AssessLaterManagementFee { get; set; }

        /// <summary>
        /// 管理绩效发放系数
        /// </summary>
        public Nullable<decimal> Management { get; set; }

        /// <summary>
        /// 考核后其他绩效
        /// </summary>
        public Nullable<decimal> AssessLaterOtherFee { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> AdjustFactor { get; set; }

        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }

        /// <summary>
        /// 规模绩效系数
        /// </summary>
        public decimal Scale { get; set; }

        /// <summary>
        /// 规模绩效
        /// </summary>
        public decimal ScalePerfor { get; set; }

        /// <summary>
        /// 效率绩效系数
        /// </summary>
        public decimal Effic { get; set; }

        /// <summary>
        /// 效率绩效
        /// </summary>
        public decimal EfficPerfor { get; set; }

        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 发放系数
        /// </summary>
        public decimal Grant { get; set; }

        /// <summary>
        /// 应发管理绩效
        /// </summary>
        public decimal ShouldGiveFee { get; set; }

        /// <summary>
        /// 其他管理绩效
        /// </summary>
        public decimal OtherManagePerfor { get; set; }

        ///// <summary>
        ///// 保底绩效参考标准
        ///// </summary>
        //public string MinimumReference { get; set; }

        ///// <summary>
        ///// 保底绩效系数
        ///// </summary>
        //public Nullable<decimal> MinimumFactor { get; set; }

        ///// <summary>
        ///// 工作量倾斜系数
        ///// </summary>
        //public Nullable<decimal> WorkSlopeFactor { get; set; }

        #endregion EXCEL读取

        #region 由计算得出

        ///// <summary>
        ///// 药占比系数
        ///// </summary>
        //public Nullable<decimal> MedicineFactor { get; set; }

        ///// <summary>
        ///// 保底绩效金额
        ///// </summary>
        //public Nullable<decimal> MinimumFee { get; set; }

        /// <summary>
        /// 科室业绩
        /// </summary>
        public Nullable<decimal> Income { get; set; }

        /// <summary>
        /// 业绩绩效
        /// </summary>
        public Nullable<decimal> PerforFee { get; set; }

        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> WorkloadFee { get; set; }

        /// <summary>
        /// 绩效合计 考核前
        /// </summary>
        public Nullable<decimal> PerforTotal { get; set; }

        /// <summary>
        /// 绩效合计 考核后
        /// </summary>
        public Nullable<decimal> AssessLaterPerforTotal { get; set; }

        /// <summary>
        /// 人均绩效
        /// </summary>
        public Nullable<decimal> Avg { get; set; }

        /// <summary>
        /// 人均核算绩效
        /// </summary>
        public Nullable<decimal> AvgPerfor { get; set; }

        /// <summary>
        /// 实发绩效
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }

        /// <summary>
        /// 是否需要二次分配
        /// </summary>
        public string NeedSecondAllot { get; set; }

        /// <summary>
        /// 夜班绩效
        /// </summary>
        public Nullable<decimal> NightShiftWorkPerforFee { get; set; }

        #endregion 由计算得出

        
        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 核算单元类型
        /// </summary>
        public string AccountType { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        public string JobNumber { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }

        /// <summary>
        /// 绩效基础核算参考值
        /// </summary>
        public Nullable<decimal> FitPeopleValue { get; set; }
        
        /// <summary>
        /// 绩效基础核算系数
        /// </summary>
        public Nullable<decimal> FitPeopleRatio { get; set; }
        /// <summary>
        /// 基础绩效系数
        /// </summary>
        public Nullable<decimal> Basics { get; set; }

        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 考核后绩效
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }
    }
}
