﻿using Performance.EntityModels;
using Performance.Repository;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Services
{
    public class CommonService : IAutoInjection
    {
        private readonly PerforVersionRepository _versionRepository;

        public CommonService(PerforVersionRepository versionRepository)
        {
            _versionRepository = versionRepository;
        }

        public List<sys_version> GetVersions(int take = 50)
        {
            var vers = _versionRepository.GetEntities() ?? new List<sys_version>();
            return vers.OrderByDescending(w => w.PublishTime).Take(take).ToList();
        }
    }
}
