﻿using Performance.DtoModels;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Services
{
    public class ComputeConfig
    {
        public static List<cof_alias> PerformanceTotal(string route, string[] heads)
        {
            if (heads == null || heads.Length == 0 || (heads.Length > 0 && heads[0] == ""))
            {
                if (route == "/report/wholehospital_grant_summary")
                    return AllComputeView.ToList();
                if (route == "/report/wholehospital_accounting_grant_summary")
                    return AllComputeDepartmentView.ToList();
                if (route == "/report/wholehospital_finance_grant_summary")
                    return AllComputePersonView.ToList();
            }
            if (route == "/report/wholehospital_grant_summary")
                return AllComputeView.Where(t => heads.Contains(t.Name.ToLower())).ToList();
            if (route == "/report/wholehospital_accounting_grant_summary")
                return AllComputeDepartmentView.Where(t => heads.Contains(t.Name.ToLower())).ToList();
            if (route == "/report/wholehospital_finance_grant_summary")
                return AllComputePersonView.Where(t => heads.Contains(t.Name.ToLower())).ToList();
            return null;
        }

        public static List<cof_alias> AllComputeView { get; } = new List<cof_alias>
        {
            new cof_alias{ Alias = "来源", Name = nameof(view_allot_sign_emp.Source), States = 1, SumStatus = 0, Sort = 1 },
            new cof_alias{ Alias = "核算组别", Name = nameof(view_allot_sign_emp.UnitType), States = 1, SumStatus = 0, Sort = 2 },
            new cof_alias{ Alias = "核算单元编码", Name = nameof(view_allot_sign_emp.Code), States = 1, SumStatus = 0, Sort = 2 },
            new cof_alias{ Alias = "核算单元", Name = nameof(view_allot_sign_emp.AccountingUnit), States = 1, SumStatus = 0, Sort = 3 },

            new cof_alias{ Alias = "员工号", Name = nameof(view_allot_sign_emp.JobNumber), States = 1, SumStatus = 0, Sort = 4 },
            new cof_alias{ Alias = "人员姓名", Name = nameof(view_allot_sign_emp.EmployeeName), States = 1, SumStatus = 0, Sort = 5 },
            new cof_alias{ Alias = "职称", Name = nameof(view_allot_sign_emp.TitlePosition), States = 1, SumStatus = 0, Sort = 6 },
            new cof_alias{ Alias = "批次", Name = nameof(view_allot_sign_emp.Batch), States = 1, SumStatus = 0, Sort = 7 },
            new cof_alias{ Alias = "银行卡号", Name = nameof(view_allot_sign_emp.BankCard), States = 1, SumStatus = 0, Sort = 8 },
            new cof_alias{ Alias = "正式/临聘", Name = nameof(view_allot_sign_emp.JobCategory), States = 1, SumStatus = 0, Sort = 9 },

            new cof_alias{ Alias = "职务", Name = nameof(view_allot_sign_emp.Duty), States = 1, SumStatus = 0, Sort = 10 },

            new cof_alias{ Alias = "调节后业绩绩效", Name = nameof(view_allot_sign_emp.PerforSumFee), States = 1, SumStatus = 1, Sort = 11 },
            new cof_alias{ Alias = "调节后实发管理绩效", Name = nameof(view_allot_sign_emp.PerforManagementFee), States = 1, SumStatus = 1, Sort = 12 },
            new cof_alias{ Alias = "调节后其他绩效", Name = nameof(view_allot_sign_emp.AdjustLaterOtherFee), States = 1, SumStatus = 1, Sort = 13 },
            new cof_alias{ Alias = "夜班费", Name = nameof(view_allot_sign_emp.NightWorkPerfor), States = 1, SumStatus = 1, Sort = 14 },
            new cof_alias{ Alias = "医院其他绩效", Name = nameof(view_allot_sign_emp.OtherPerfor), States = 1, SumStatus = 1, Sort = 15 },
            new cof_alias{ Alias = "不公示其他绩效", Name = nameof(view_allot_sign_emp.HideOtherPerfor), States = 1, SumStatus = 1, Sort = 16 },
            new cof_alias{ Alias = "应发小计", Name = nameof(view_allot_sign_emp.ShouldGiveFee), States = 1, SumStatus = 1, Sort = 17 },
            new cof_alias{ Alias = "预留绩效", Name = nameof(view_allot_sign_emp.ReservedRatioFee), States = 1, SumStatus = 1, Sort = 18 },
            new cof_alias{ Alias = "实发绩效", Name = nameof(view_allot_sign_emp.RealGiveFee), States = 1, SumStatus = 1, Sort = 19 },
        };

        private static List<cof_alias> _allComputeViewByDate = new List<cof_alias>();

        public static List<cof_alias> AllComputeViewByDate
        {
            get
            {
                if (_allComputeViewByDate == null || _allComputeViewByDate.Count == 0)
                {
                    _allComputeViewByDate.Add(new cof_alias { Alias = "年份", Name = nameof(view_allot_sign_emp.Year), States = 1, SumStatus = 0 });
                    _allComputeViewByDate.Add(new cof_alias { Alias = "月份", Name = nameof(view_allot_sign_emp.Month), States = 1, SumStatus = 0 });
                    _allComputeViewByDate.AddRange(AllComputeView);
                }
                return _allComputeViewByDate;
            }
        }

        public static List<cof_alias> AllComputePersonView { get; } = new List<cof_alias>
        {
            new cof_alias{ Alias = "核算组别", Name = nameof(view_allot_sign_emp.UnitType), States = 1, SumStatus = 0, Sort = 1 },
            new cof_alias{ Alias = "核算单元编码", Name = nameof(view_allot_sign_emp.Code), States = 1, SumStatus = 0, Sort = 2 },
            new cof_alias{ Alias = "核算单元", Name = nameof(view_allot_sign_emp.AccountingUnit), States = 1, SumStatus = 0, Sort = 2 },
            new cof_alias{ Alias = "员工号", Name = nameof(view_allot_sign_emp.JobNumber), States = 1, SumStatus = 0, Sort = 3 },
            new cof_alias{ Alias = "人员姓名", Name = nameof(view_allot_sign_emp.EmployeeName), States = 1, SumStatus = 0, Sort = 4 },
            new cof_alias{ Alias = "调节后业绩绩效", Name = nameof(view_allot_sign_emp.PerforSumFee), States = 1, SumStatus = 1, Sort = 5 },
            new cof_alias{ Alias = "调节后实发管理绩效", Name = nameof(view_allot_sign_emp.PerforManagementFee), States = 1, SumStatus = 1, Sort = 6 },
            new cof_alias{ Alias = "调节后其他绩效", Name = nameof(view_allot_sign_emp.AdjustLaterOtherFee), States = 1, SumStatus = 1, Sort = 7 },
            new cof_alias{ Alias = "夜班费", Name = nameof(view_allot_sign_emp.NightWorkPerfor), States = 1, SumStatus = 1, Sort = 8 },
            new cof_alias{ Alias = "医院其他绩效", Name = nameof(view_allot_sign_emp.OtherPerfor), States = 1, SumStatus = 1, Sort = 9 },
            new cof_alias{ Alias = "不公示其他绩效", Name = nameof(view_allot_sign_emp.HideOtherPerfor), States = 1, SumStatus = 1, Sort = 10 },
            new cof_alias{ Alias = "应发小计", Name = nameof(view_allot_sign_emp.ShouldGiveFee), States = 1, SumStatus = 1, Sort = 11 },
            new cof_alias{ Alias = "预留绩效", Name = nameof(view_allot_sign_emp.ReservedRatioFee), States = 1, SumStatus = 1, Sort = 12 },
            new cof_alias{ Alias = "实发绩效", Name = nameof(view_allot_sign_emp.RealGiveFee), States = 1, SumStatus = 1, Sort = 13 },
        };

        private static List<cof_alias> _allComputePersonViewByDate = new List<cof_alias>();

        public static List<cof_alias> AllComputePersonViewByDate
        {
            get
            {
                if (_allComputePersonViewByDate == null || _allComputePersonViewByDate.Count == 0)
                {
                    _allComputePersonViewByDate.Add(new cof_alias { Alias = "年份", Name = nameof(view_allot_sign_emp.Year), States = 1, SumStatus = 0 });
                    _allComputePersonViewByDate.Add(new cof_alias { Alias = "月份", Name = nameof(view_allot_sign_emp.Month), States = 1, SumStatus = 0 });
                    _allComputePersonViewByDate.AddRange(AllComputePersonView);
                }
                return _allComputePersonViewByDate;
            }
        }

        public static List<cof_alias> AllComputeDepartmentView { get; } = new List<cof_alias>
        {
            new cof_alias{ Alias = "核算组别", Name = nameof(view_allot_sign_dept.UnitType), States = 1, SumStatus = 0, Sort = 1 },
            new cof_alias{ Alias = "核算单元编码", Name = nameof(view_allot_sign_emp.Code), States = 1, SumStatus = 0, Sort = 2 },
            new cof_alias{ Alias = "核算单元", Name = nameof(view_allot_sign_dept.AccountingUnit), States = 1, SumStatus = 0, Sort = 2 },
            new cof_alias{ Alias = "业绩绩效", Name = nameof(view_allot_sign_dept.PerforFee), States = 1, SumStatus = 1, Sort = 3 },
            new cof_alias{ Alias = "工作量绩效", Name = nameof(view_allot_sign_dept.WorkloadFee), States = 1, SumStatus = 1, Sort = 4 },
            new cof_alias{ Alias = "考核前其他绩效", Name = nameof(view_allot_sign_dept.AssessBeforeOtherFee), States = 1, SumStatus = 1, Sort = 5 },
            new cof_alias{ Alias = "考核前绩效合计", Name = nameof(view_allot_sign_dept.PerforTotal), States = 1, SumStatus = 1, Sort = 6 },
            new cof_alias{ Alias = "科室考核得分", Name = nameof(view_allot_sign_dept.ScoringAverage), States = 1, SumStatus = 1, Sort = 7 },
            new cof_alias{ Alias = "药占比奖罚", Name = nameof(view_allot_sign_dept.MedicineExtra), States = 1, SumStatus = 1, Sort = 8 },
            new cof_alias{ Alias = "材料占比奖罚", Name = nameof(view_allot_sign_dept.MaterialsExtra), States = 1, SumStatus = 1, Sort = 9 },
            new cof_alias{ Alias = "医院奖罚", Name = nameof(view_allot_sign_dept.Extra), States = 1, SumStatus = 1, Sort = 10 },
            new cof_alias{ Alias = "考核后其他绩效", Name = nameof(view_allot_sign_dept.AssessLaterOtherFee), States = 1, SumStatus = 1, Sort = 11 },
            new cof_alias{ Alias = "考核后绩效", Name = nameof(view_allot_sign_dept.AssessLaterPerforTotal), States = 1, SumStatus = 1, Sort = 12 },
            new cof_alias{ Alias = "调节系数", Name = nameof(view_allot_sign_dept.AdjustFactor), States = 1, SumStatus = 1, Sort = 13 },
            new cof_alias{ Alias = "调节后其他绩效", Name = nameof(view_allot_sign_dept.AdjustLaterOtherFee), States = 1, SumStatus = 1, Sort = 14 },
            new cof_alias{ Alias = "科主任实发管理绩效", Name = nameof(view_allot_sign_dept.AssessLaterManagementFee), States = 1, SumStatus = 1, Sort = 15 },
            new cof_alias{ Alias = "医院其他绩效", Name = nameof(view_allot_sign_dept.AprPerforAmount), States = 1, SumStatus = 1, Sort = 16 },
            new cof_alias{ Alias = "不公示其他绩效", Name = nameof(view_allot_sign_dept.HideAprOtherPerforAmount), States = 1, SumStatus = 1, Sort = 17 },
            new cof_alias{ Alias = "实发绩效", Name = nameof(view_allot_sign_dept.RealGiveFee), States = 1, SumStatus = 1, Sort = 18 },
        };

        private static List<cof_alias> _allComputeDepartmentViewByDate = new List<cof_alias>();

        public static List<cof_alias> AllComputeDepartmentViewByDate
        {
            get
            {
                if (_allComputeDepartmentViewByDate == null || _allComputeDepartmentViewByDate.Count == 0)
                {
                    _allComputeDepartmentViewByDate.Add(new cof_alias { Alias = "年份", Name = nameof(view_allot_sign_emp.Year), States = 1, SumStatus = 0 });
                    _allComputeDepartmentViewByDate.Add(new cof_alias { Alias = "月份", Name = nameof(view_allot_sign_emp.Month), States = 1, SumStatus = 0 });
                    _allComputeDepartmentViewByDate.AddRange(AllComputeDepartmentView);
                }
                return _allComputeDepartmentViewByDate;
            }
        }


        public static List<cof_alias> GetAllPersonnelTags(bool ownerQuery)
        {
            var alias = new List<cof_alias>
            {
                new cof_alias{ Alias = "员工工号", Name = nameof(per_employee.PersonnelNumber), States = 1, SumStatus = 0, Sort = 2 },
                new cof_alias{ Alias = "姓名", Name = nameof(per_employee.DoctorName), States = 1, SumStatus = 0, Sort = 4 },
                new cof_alias{ Alias = "核算单元", Name = nameof(per_employee.AccountingUnit), States = 1, SumStatus = 0, Sort = 6 },


                new cof_alias{ Alias = "正式/临聘", Name = nameof(per_employee.JobCategory), States = 1, SumStatus = 0, Sort = 8 },
                new cof_alias{ Alias = "职务", Name = nameof(per_employee.Duty), States = 1, SumStatus = 0, Sort = 10 },
                new cof_alias{ Alias = "职称", Name = nameof(per_employee.JobTitle), States = 1, SumStatus = 0, Sort = 12 },
                new cof_alias{ Alias = "出勤天数", Name = nameof(per_employee.AttendanceDay), States = 1, SumStatus = 0, Sort = 14 },
                new cof_alias{ Alias = "预留比例", Name = nameof(per_employee.ReservedRatio), States = 1, SumStatus = 0, Sort = 16 },
                new cof_alias{ Alias = "银行卡号", Name = nameof(per_employee.BankCard), States = 1, SumStatus = 0, Sort = 18 },

                new cof_alias{ Alias = "备用01", Name = nameof(per_employee.Reserve01), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用02", Name = nameof(per_employee.Reserve02), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用03", Name = nameof(per_employee.Reserve03), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用04", Name = nameof(per_employee.Reserve04), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用05", Name = nameof(per_employee.Reserve05), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用06", Name = nameof(per_employee.Reserve06), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用07", Name = nameof(per_employee.Reserve07), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用08", Name = nameof(per_employee.Reserve08), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用09", Name = nameof(per_employee.Reserve09), States = 0, SumStatus = 0, Sort = 20 },
                new cof_alias{ Alias = "备用10", Name = nameof(per_employee.Reserve10), States = 0, SumStatus = 0, Sort = 20 },

                new cof_alias{ Alias = "绩效发放情况", Name = nameof(report_performance_person_tags.Tag1), States = 1, SumStatus = 0, Sort = 100 },
                new cof_alias{ Alias = "当月绩效权重", Name = nameof(report_performance_person_tags.Tag2), States = 1, SumStatus = 0, Sort = 101 },
                new cof_alias{ Alias = "重点群体对比1", Name = nameof(report_performance_person_tags.Tag3), States = 1, SumStatus = 0, Sort = 102 },
                new cof_alias{ Alias = "重点群体对比2", Name = nameof(report_performance_person_tags.Tag4), States = 1, SumStatus = 0, Sort = 103 },
                new cof_alias{ Alias = "重点群体对比5", Name = nameof(report_performance_person_tags.Tag5), States = 1, SumStatus = 0, Sort = 104 },
            };
            if (ownerQuery)
                alias.Add(new cof_alias { Alias = "密码", Name = "Password", States = 1, SumStatus = 0, Sort = 7 });

            return alias.OrderBy(w => w.Sort).ToList();
        }
    }
}
