//-----------------------------------------------------------------------
// <copyright file=" per_dept_dic.cs">
// * FileName: 科室字典表.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 科室字典表
    /// </summary>
    [Table("per_dept_dic")]
    public class per_dept_dic
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// his系统科室名称
        /// </summary>
        public string HISDeptName { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 核算单元类型
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 来源住院/门诊
        /// </summary>
        public string Source { get; set; }

        /// <summary>
        /// 医院Id
        /// </summary>
        public Nullable<int> HospitalId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> CreateTime { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }

        /// <summary>
        /// 0 未通过验证 1 通过验证
        /// </summary>
        public int? IsVerify { get; set; }

        /// <summary>
        /// 验证失败描述
        /// </summary>
        public string VerifyMessage { get; set; }
    }
}
