﻿using Microsoft.Extensions.Options;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;
using Performance.Repository;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class TemplateService : IAutoInjection
    {
        private IEmailService emailService;
        private PerforPerfirstRepository PerforPerfirstRepository;
        public TemplateService(IEmailService emailService,
            PerforPerfirstRepository PerforPerfirstRepository)
        {
            this.emailService = emailService;
            this.PerforPerfirstRepository = PerforPerfirstRepository;
        }

        /// <summary>
        /// 添加数据 per_first
        /// </summary>
        /// <param name="first"></param>
        /// <returns></returns>
        public bool InsertFirst(per_first first)
        {
            return PerforPerfirstRepository.Add(first);
        }

        #region 发送邮件
        /// <summary>
        /// 发送邮件
        /// </summary>
        /// <param name="path"></param>
        /// <param name="subject"></param>
        /// <param name="body"></param>
        public void SendEmail(List<string> receiver, string path, string subject, string body)
        {
            var message = new EmailMessage
            {
                To = receiver,
                Attachments = new List<string> { path },
                DisplayName = "溯直健康",
                Subject = subject,
                Body = body

            };
            emailService.Send(message);
        }
        #endregion
    }
}
