﻿using Performance.EntityModels;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Repository
{
    public partial class PerforCofaccountingRepository : PerforRepository<cof_accounting>
    {
        public List<CofAccountingEntity> GetAccounting(params int[] hospitalIds)
        {
            var cofAccountings = from p in context.Set<per_allot>().Where(w => hospitalIds.Contains(w.HospitalId))
                                 join a in context.Set<cof_accounting>()
                                 on p.ID equals a.AllotId
                                 select new { Allot = p, Accounting = a };

            return cofAccountings
                .Select(w => new { w.Allot.HospitalId, w.Accounting.AccountingUnit, w.Accounting.UnitType, w.Accounting.Code })
                .Distinct()
                .Select(w => new CofAccountingEntity
                {
                    HospitalId = w.HospitalId,
                    Code = w.Code,
                    UnitType = w.UnitType,
                    AccountingUnit = w.AccountingUnit,
                })
                .ToList();
        }
    }

}
