﻿using Dapper;
using Microsoft.Extensions.Options;
using MySql.Data.MySqlClient;
using Performance.DtoModels.AppSettings;
using System;
using System.Data;
using System.Threading.Tasks;

namespace Performance.Services
{
    public class DapperService : IAutoInjection
    {
        private readonly IOptions<AppConnection> _options;

        public DapperService(IOptions<AppConnection> options)
        {
            _options = options;
        }

        #region 数据静态存储
        /// <summary>
        /// 数据静态存储
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        public void FreezeAllotSync(int allotId)
        {
            Task.Factory.StartNew(() => FreezeAllot(allotId));
        }

        /// <summary>
        /// 数据静态存储
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        public void FreezeAllot(int allotId)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();
                try
                {
                    string sql = $@"call proc_freeze_allot({allotId})";
                    connection.Execute(sql, commandTimeout: 60 * 60);
                }
                catch (Exception)
                {
                    throw;
                }
            }
        }
        #endregion

        #region 二次分配模板修复
        /// <summary>
        /// 二次分配模板修复
        /// </summary>
        /// <param name="allotId"></param>
        public void SecondUseTempRestoreSync()
        {
            Task.Factory.StartNew(() =>
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    try
                    {
                        string sql = $@"call proc_second_restore()";
                        connection.Execute(sql, commandTimeout: 60 * 60);
                    }
                    catch (Exception)
                    {
                        throw;
                    }
                }
            });
        }
        #endregion

        #region 清理无效绩效数据
        /// <summary>
        /// 清理无效绩效数据
        /// </summary>
        /// <param name="allotId"></param>
        public void ClearAllotSync()
        {
            Task.Factory.StartNew(() =>
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    try
                    {
                        string sql = $@"call proc_clear_allot()";
                        connection.Execute(sql, commandTimeout: 60 * 60);
                    }
                    catch (Exception)
                    {
                        throw;
                    }
                }
            });
        }
        #endregion
    }
}
