﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Performance.DtoModels.AppSettings;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Configurations
{
    public static class AppSettingConfig
    {
        public static void AddAppSettingConfiguration(this IServiceCollection services, IConfiguration configuration)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            services
                .Configure<AppConnection>(configuration.GetSection("AppConnection"))
                .Configure<Application>(configuration.GetSection("Application"))
                .Configure<HuyiSmsConfig>(configuration.GetSection("HuyiSmsConfig"))
                .Configure<EmailOptions>(configuration.GetSection("EmailOptions"))
                .Configure<WebapiUrl>(configuration.GetSection("WebapiUrl"));
        }
    }
}
