﻿using GraphQL;
using GraphQL.Types;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api
{
    public static class GraphQLExtension
    {
        public static void AddGraphQLSchemaAndTypes(this IServiceCollection services)
        {
            services.AddScoped<ChartDataType>();
            services.AddScoped<ReportDataType>();
            services.AddScoped<ReportPerformanceType>();
            services.AddScoped<PerformanceQuery>();
            services.AddScoped<ISchema, PerformanceSchema>();
            services.AddScoped<IDocumentExecuter, DocumentExecuter>();
            services.AddScoped<IDependencyResolver>(provider => new FuncDependencyResolver
            (
                type => provider.GetRequiredService(type)
            ));
        }
    }
}
