﻿using Performance.EntityModels;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Repository
{
    public partial class PerforAgsecondallotRepository : PerforRepository<ag_secondallot>
    {
        /// <summary>
        /// 删除已提交的历史记录（ag_compute）
        /// </summary>
        /// <param name="secondId"></param>
        /// <returns></returns>
        public int DeleteComputeHistory(int secondId)
        {
            return Execute("DELETE FROM ag_compute WHERE SecondId = @secondId", new { secondId });
        }

        /// <summary>
        /// 查询二次分配结果 根据AllotId
        /// </summary>
        /// <param name="secondId"></param>
        /// <returns></returns>
        public List<view_second_compute_collect> GetComputeByAllot(int allotId)
        {
            var datas = DapperQuery<view_second_compute_collect>("SELECT * FROM view_second_compute_collect WHERE AllotId = @allotId", new { allotId });
            if (datas != null)
                return datas.ToList();

            return new List<view_second_compute_collect>();
        }
        /// <summary>
        /// 查询二次分配结果 根据SecondId
        /// </summary>
        /// <param name="secondId"></param>
        /// <returns></returns>
        public List<view_second_compute_collect> GetComputeBySecond(int secondId)
        {
            var datas = DapperQuery<view_second_compute_collect>("SELECT * FROM view_second_compute_collect WHERE SecondId = @secondId", new { secondId });
            if (datas != null)
                return datas.ToList();

            return new List<view_second_compute_collect>();
        }
    }
}
