﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Subsidy
{
    public class ApiResponse<TEntity>
        where TEntity : class, new()
    {
        public Status State { get; set; }
        /// <summary>
        /// 消息内容。
        /// </summary>
        public string Message { get; set; }
        /// <summary>
        /// 返回数据。
        /// </summary>
        public TEntity Data { get; set; }

        public ApiResponse()
            : this(Status.Fail, "", null)
        {
        }
        public ApiResponse(Status type)
            : this(type, type.ToString(), null)
        {
        }

        public ApiResponse(Status type, string message)
            : this(type, message, null)
        {
        }

        public ApiResponse(Status type, TEntity entity)
            : this(type, type.ToString(), entity)
        {
        }

        public ApiResponse(Status type, string message, TEntity entity)
        {
            State = type;
            Message = message;
            Data = entity;
        }
    }

    public sealed class ApiResponse : ApiResponse<Object>
    {
        public ApiResponse()
        {
        }

        public ApiResponse(Status type) : base(type)
        {
        }

        public ApiResponse(Status type, string message) : base(type, message)
        {
        }

        public ApiResponse(Status type, object entity) : base(type, entity)
        {
        }

        public ApiResponse(Status type, string message, object entity) : base(type, message, entity)
        {
        }
    }
}
