﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using Microsoft.Extensions.Options;
using Newtonsoft.Json.Linq;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.Infrastructure;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class MenuController : Controller
    {
        private MenuService _menuService;
        private ClaimService _claim;
        public MenuController(MenuService menuService, ClaimService claimService)
        {
            _menuService = menuService;
            _claim = claimService;
        }

        /// <summary>
        /// 设置用户管辖医院
        /// </summary>
        /// <returns></returns>
        [Route("menulist")]
        [HttpPost]
        public ApiResponse<List<MenuResponse>> MenuList()
        {
            var menuList = _menuService.GetMenuList(_claim.GetUserId());
            return new ApiResponse<List<MenuResponse>>(ResponseType.OK, menuList);
        }
    }
}
