﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using Performance.Services.ExtractExcelService;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class DownloadService : IAutoInjection
    {
        private readonly ILogger<DownloadService> logger;
        private readonly PerforPerallotRepository perallotRepository;
        private readonly PerforHospitalRepository perforHospital;
        private readonly ConfigService configService;
        private readonly IHostingEnvironment evn;

        public DownloadService(ILogger<DownloadService> logger,
            PerforPerallotRepository perallotRepository,
            PerforHospitalRepository perforHospital,
            ConfigService configService,
            IHostingEnvironment evn)
        {
            this.logger = logger;
            this.perallotRepository = perallotRepository;
            this.perforHospital = perforHospital;
            this.configService = configService;
            this.evn = evn;
        }




        #region 财务、全院绩效发放下载


        /// <summary>
        /// 财务、全院绩效发放下载
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="allData"></param>
        /// <param name="isAll"></param>
        /// <returns></returns>
        public string AllComputerReport(int allotId, List<ComputeResponse> allData, bool isAll)
        {
            var allot = perallotRepository.GetEntity(t => t.ID == allotId);
            var hospital = perforHospital.GetEntity(t => t.ID == allot.HospitalId);

            var headList = AllCompute;
            if (!isAll)
                headList = Person;

            var dpath = Path.Combine(evn.ContentRootPath, "Files", "PerformanceRelease", $"{allot.HospitalId}");
            FileHelper.CreateDirectory(dpath);

            string fileName = $"{hospital.HosName}-全院绩效发放-{DateTime.Now:yyyy年MM月dd日}";
            string filepath = Path.Combine(dpath, fileName);
            FileStream stream = new FileStream(filepath, FileMode.Create);
            try
            {
                HSSFWorkbook workbook = new HSSFWorkbook();
                //设置单元格样式
                ICellStyle style = workbook.CreateCellStyle();
                style.Alignment = HorizontalAlignment.Center;
                style.BorderBottom = BorderStyle.Thin;
                style.BorderRight = BorderStyle.Thin;

                ISheet sheet = workbook.CreateSheet("全院绩效发放");
                sheet.ForceFormulaRecalculation = true;
                ICellStyle cellStyle = workbook.CreateCellStyle();
                cellStyle.DataFormat = HSSFDataFormat.GetBuiltinFormat("0.00");

                IRow row1 = sheet.CreateRow(0);
                row1.CreateCell(0).SetCellValue("序号");
                row1.GetCell(0).CellStyle = style;

                int cellIndex = 1;
                foreach (var item in headList.Select(t => t.Item2))
                {
                    row1.CreateCell(cellIndex).SetCellValue(item);
                    row1.GetCell(cellIndex).CellStyle = style;
                    sheet.SetColumnWidth(cellIndex, 14 * 256);
                    cellIndex++;
                }

                int startIndex = 1;
                foreach (var item in allData)
                {
                    var row = sheet.CreateRow(startIndex);
                    cellIndex = 1;
                    var serial = row.CreateCell(0);
                    serial.SetCellOValue(startIndex);
                    serial.CellStyle = style;
                    foreach (var field in headList.Select(t => t.Item3))
                    {
                        var cell = row.CreateCell(cellIndex);
                        cell.SetCellOValue(field?.Invoke(item));
                        cell.CellStyle = style;
                        cellIndex++;
                    }
                    startIndex++;
                }
                //合计
                cellIndex = 1;
                var totalRow = sheet.CreateRow(startIndex);
                var totalSerial = totalRow.CreateCell(0);
                totalSerial.SetCellOValue("合计");
                totalSerial.CellStyle = style;
                foreach (var value in headList.Select(t => t.Item4))
                {
                    var cell = totalRow.CreateCell(cellIndex);
                    cell.SetCellFormula(string.Format(value, startIndex));
                    cell.CellStyle = style;
                    cellIndex++;
                }

                workbook.Write(stream);
            }
            catch (Exception ex)
            {
                Console.WriteLine("下载异常" + ex);
            }
            finally
            {
                stream.Close();
            }
            return filepath;
        }

        public static List<(string, string, Func<ComputeResponse, object>, string)> AllCompute { get; } = new List<(string, string, Func<ComputeResponse, object>, string)>
        {
            (nameof(ComputeResponse.Source), "来源",t=>t.Source,""),
            (nameof(ComputeResponse.UnitType), "科室类别",t=>t.UnitType,""),
            (nameof(ComputeResponse.AccountingUnit), "核算单元",t=>t.AccountingUnit,""),
            (nameof(ComputeResponse.JobNumber), "员工号",t=>t.JobNumber,""),
            (nameof(ComputeResponse.EmployeeName), "人员姓名",t=>t.EmployeeName,""),
            (nameof(ComputeResponse.JobTitle), "职务",t=>t.JobTitle,""),
            (nameof(ComputeResponse.Batch), "批次",t=>t.Batch,""),
            (nameof(ComputeResponse.PerforSumFee), "调节后业绩绩效",t=>t.PerforSumFee,"SUM(I2:I{0})"),
            (nameof(ComputeResponse.PerforManagementFee), "调节后实发管理绩效",t=>t.PerforManagementFee,"SUM(J2:J{0})"),
            (nameof(ComputeResponse.AdjustLaterOtherFee), "调节后其他绩效",t=>t.AdjustLaterOtherFee,"SUM(K2:K{0})"),
            (nameof(ComputeResponse.NightWorkPerfor), "夜班费",t=>t.NightWorkPerfor,"SUM(L2:L{0})"),
            (nameof(ComputeResponse.OthePerfor), "医院其他绩效",t=>t.OthePerfor,"SUM(M2:M{0})"),
            (nameof(ComputeResponse.HideOtherPerfor), "不公示其他绩效",t=>t.HideOtherPerfor,"SUM(N2:N{0})"),
            (nameof(ComputeResponse.ShouldGiveFee), "应发小计",t=>t.ShouldGiveFee,"SUM(O2:O{0})"),
            (nameof(ComputeResponse.ReservedRatioFee), "预留绩效",t=>t.ReservedRatioFee,"SUM(P2:P{0})"),
            (nameof(ComputeResponse.RealGiveFee), "实发绩效",t=>t.RealGiveFee,"SUM(Q2:Q{0})"),
        };

        public static List<(string, string, Func<ComputeResponse, object>, string)> Person { get; } = new List<(string, string, Func<ComputeResponse, object>, string)>
        {
            (nameof(ComputeResponse.UnitType), "科室类别",t=>t.UnitType,""),
            (nameof(ComputeResponse.AccountingUnit), "核算单元",t=>t.AccountingUnit,""),
            (nameof(ComputeResponse.JobNumber), "员工号",t=>t.JobNumber,""),
            (nameof(ComputeResponse.EmployeeName), "人员姓名",t=>t.EmployeeName,""),
            (nameof(ComputeResponse.PerforSumFee), "调节后业绩绩效",t=>t.PerforSumFee,"SUM(F2:F{0})"),
            (nameof(ComputeResponse.PerforManagementFee), "调节后实发管理绩效",t=>t.PerforManagementFee,"SUM(G2:G{0})"),
            (nameof(ComputeResponse.AdjustLaterOtherFee), "调节后其他绩效",t=>t.AdjustLaterOtherFee,"SUM(H2:H{0})"),
            (nameof(ComputeResponse.NightWorkPerfor), "夜班费",t=>t.NightWorkPerfor,"SUM(I2:I{0})"),
            (nameof(ComputeResponse.OthePerfor), "医院其他绩效",t=>t.OthePerfor,"SUM(J2:J{0})"),
            (nameof(ComputeResponse.HideOtherPerfor), "不公示其他绩效",t=>t.HideOtherPerfor,"SUM(K2:K{0})"),
            (nameof(ComputeResponse.ShouldGiveFee), "应发小计",t=>t.ShouldGiveFee,"SUM(L2:L{0})"),
            (nameof(ComputeResponse.ReservedRatioFee), "预留绩效",t=>t.ReservedRatioFee,"SUM(M2:M{0})"),
            (nameof(ComputeResponse.RealGiveFee), "实发绩效",t=>t.RealGiveFee,"SUM(N2:N{0})"),
        };
        #endregion

        #region 全院绩效核算


        /// <summary>
        /// 全院绩效核算
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="name"></param>
        /// <param name="deptData"></param>
        /// <returns></returns>
        public string DeptReport(int allotId, List<DeptResponse> deptData)
        {
            var allot = perallotRepository.GetEntity(t => t.ID == allotId);
            var hospital = perforHospital.GetEntity(t => t.ID == allot.HospitalId);

            var dpath = Path.Combine(evn.ContentRootPath, "Files", "PerformanceRelease", $"{allot.HospitalId}");
            FileHelper.CreateDirectory(dpath);

            string fileName = $"{hospital.HosName}-全院核算绩效发放-{DateTime.Now:yyyy年MM月dd日}";
            string filepath = Path.Combine(dpath, fileName);
            FileStream stream = new FileStream(filepath, FileMode.Create);
            try
            {
                HSSFWorkbook workbook = new HSSFWorkbook();
                //设置单元格样式
                ICellStyle style = workbook.CreateCellStyle();
                style.Alignment = HorizontalAlignment.Center;
                style.BorderBottom = BorderStyle.Thin;
                style.BorderRight = BorderStyle.Thin;

                ISheet sheet = workbook.CreateSheet("全院核算绩效发放");
                sheet.ForceFormulaRecalculation = true;
                ICellStyle cellStyle = workbook.CreateCellStyle();
                cellStyle.DataFormat = HSSFDataFormat.GetBuiltinFormat("0.00");

                IRow row1 = sheet.CreateRow(0);
                int cellIndex = 0;
                foreach (var item in HosData.Select(t => t.Item2))
                {
                    row1.CreateCell(cellIndex).SetCellValue(item);
                    row1.GetCell(cellIndex).CellStyle = style;
                    sheet.SetColumnWidth(cellIndex, 14 * 256);
                    cellIndex++;
                }

                int startIndex = 1;
                foreach (var item in deptData)
                {
                    var row = sheet.CreateRow(startIndex);
                    cellIndex = 0;
                    foreach (var field in HosData.Select(t => t.Item3))
                    {
                        var cell = row.CreateCell(cellIndex);
                        cell.SetCellOValue(field?.Invoke(item));
                        cell.CellStyle = style;
                        cellIndex++;
                    }
                    startIndex++;
                }

                //合计
                cellIndex = 0;
                var totalRow = sheet.CreateRow(startIndex);

                foreach (var value in HosData.Select(t => t.Item4))
                {
                    var cell = totalRow.CreateCell(cellIndex);
                    if (cellIndex == 0)
                        cell.SetCellOValue("合计");
                    else
                        cell.SetCellFormula(string.Format(value, startIndex));
                    cell.CellStyle = style;
                    cellIndex++;
                }


                workbook.Write(stream);
            }
            catch (Exception ex)
            {
                Console.WriteLine("下载异常" + ex);
            }
            finally
            {
                stream.Close();
            }
            return filepath;
        }

        public static List<(string, string, Func<DeptResponse, object>, string)> HosData { get; } = new List<(string, string, Func<DeptResponse, object>, string)>
        {
            (nameof(DeptResponse.UnitName), "核算群体",t=>t.UnitName,""),
            (nameof(DeptResponse.AccountingUnit), "核算单元",t=>t.AccountingUnit,""),
            (nameof(DeptResponse.PerforFee), "业绩绩效",t=>t.PerforFee,"SUM(C2:C{0})"),
            (nameof(DeptResponse.WorkloadFee), "工作量绩效",t=>t.WorkloadFee,"SUM(D2:D{0})"),
            (nameof(DeptResponse.AssessBeforeOtherFee), "考核前其他绩效",t=>t.AssessBeforeOtherFee,"SUM(E2:E{0})"),
            (nameof(DeptResponse.PerforTotal), "考核前绩效合计",t=>t.PerforTotal,"SUM(F2:F{0})"),
            (nameof(DeptResponse.ScoringAverage), "科室考核得分",t=>t.ScoringAverage,"SUM(G2:G{0})"),
            (nameof(DeptResponse.MedicineExtra), "药占比奖罚",t=>t.MedicineExtra,"SUM(H2:H{0})"),
            (nameof(DeptResponse.MaterialsExtra), "材料占比奖罚",t=>t.MaterialsExtra,"SUM(I2:I{0})"),
            (nameof(DeptResponse.Extra), "医院奖罚",t=>t.Extra,"SUM(J2:J{0})"),
            (nameof(DeptResponse.ScoringPerfor), "考核后其他绩效",t=>t.ScoringPerfor,"SUM(K2:K{0})"),
            (nameof(DeptResponse.AssessLaterOtherFee), "考核后绩效",t=>t.AssessLaterOtherFee,"SUM(L2:L{0})"),
            (nameof(DeptResponse.AdjustFactor), "调节系数",t=>t.AdjustFactor,"SUM(M2:M{0})"),
            (nameof(DeptResponse.AdjustLaterOtherFee), "调节后其他绩效",t=>t.AdjustLaterOtherFee,"SUM(N2:N{0})"),
            (nameof(DeptResponse.AssessLaterManagementFee), "科主任实发管理绩效",t=>t.AssessLaterManagementFee,"SUM(O2:O{0})"),
            (nameof(DeptResponse.AprPerforAmount), "医院其他绩效",t=>t.AprPerforAmount,"SUM(P2:P{0})"),
            (nameof(DeptResponse.HideAprOtherPerforAmount), "不公示其他绩效",t=>t.HideAprOtherPerforAmount,"SUM(Q2:Q{0})"),
            (nameof(DeptResponse.RealGiveFee), "实发绩效",t=>t.RealGiveFee,"SUM(R2:R{0})"),
        };
        #endregion
    }
}
