﻿using Microsoft.AspNetCore.Mvc;
using Performance.Subsidy.Services;
using System;
using System.Collections.Generic;
using System.Net;
using System.Threading.Tasks;

namespace Performance.Subsidy.Api.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class SubsidyController : ControllerBase
    {
        private readonly SubsidyService _service;

        public SubsidyController(
            SubsidyService service)
        {
            _service = service;
        }

        /// <summary>
        /// 绩效列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [ProducesResponseType(typeof(IEnumerable<view_allot>), (int)HttpStatusCode.OK)]
        public async Task<ApiResponse> GetAllot()
        {
            var allots = await _service.GetAllot();

            return new ApiResponse(Status.Ok, allots);
        }

        /// <summary>
        ///  职称查询
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="hospitalId"></param>
        /// <returns></returns>
        [HttpGet("{allotId}/jobtitle/{hospitalId}")]
        public ApiResponse GetJobTitle(int allotId, int hospitalId)
        {
            _service.GetHrpJobTitle(allotId, hospitalId, false);
            var jobTitle = _service.GetJobTitle(allotId, hospitalId);
            return new ApiResponse(Status.Ok, jobTitle);
        }

        /// <summary>
        /// 重新查询职称
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="hospitalId"></param>
        /// <returns></returns>
        [HttpPost("{allotId}/reset-jobtitle/{hospitalId}")]
        public ApiResponse ResetJobTitle(int allotId, int hospitalId)
        {
            // 调取配置的SQL语句
            // 执行SQL 获取结果
            // 将结果存储到sub_subsidy中
            // 查询sub_subsidy表职称去重            
            // 将去重数据插入sub_jobtitle
            _service.GetHrpJobTitle(allotId, hospitalId, true);
            var jobTitle = _service.GetJobTitle(allotId, hospitalId);
            return new ApiResponse(Status.Ok, jobTitle);
        }
        
        /// <summary>
        /// 职称标准保存
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="sub_Jobtitle"></param>
        /// <returns></returns>
        [HttpPost("{allotId}/jobtitle")]
        public ApiResponse SaveJobTitle(int allotId, [FromBody] List<sub_jobtitle> sub_Jobtitle)
        {
            bool result = _service.SaveJobTitle(allotId, sub_Jobtitle);
            return new ApiResponse(Status.Ok, result);
        }

        /// <summary>
        /// 个人职称补贴结果查询
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        [HttpGet("{allotId}/jobtitle/subsidy")]
        public ApiResponse GetJobTitleSubsidy(int allotId)
        {
            List<sub_subsidy> subsidies = _service.GetJobTitleSubsidy(allotId);

            return new ApiResponse(Status.Ok, subsidies);
        }

        /// <summary>
        /// 个人职称补贴结果保存
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="subsidys"></param>
        /// <returns></returns>
        [HttpPost("{allotId}/jobtitle/subsidy")]
        public ApiResponse SaveJobTitleSubsidy(int allotId, [FromBody] List<sub_subsidy> subsidys)
        {
            bool result = _service.SaveJobTitleSubsidy(allotId, subsidys);
            return new ApiResponse(Status.Ok, result);
        }

        /// <summary>
        /// 保存个人职称补贴结果
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="subsidies"></param>
        /// <returns></returns>
        [HttpPost("{allotId}/savesubsidy")]
        public ApiResponse SaveSubsidy(int allotId,[FromBody] List<sub_subsidy> subsidies)
        {
            var result = _service.SaveSubsidy(allotId, subsidies);
            return new ApiResponse(Status.Ok, result);
        }
    }
}
