﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class AssessColumnRequest
    {
        public int ColumnID { get; set; }
        public int AssessID { get; set; }
        public int ParentID { get; set; }
        public string ColumnName { get; set; }
        public int Sort { get; set; }
    }

    public class AssessColumnRequestValidator : AbstractValidator<AssessColumnRequest>
    {
        public AssessColumnRequestValidator()
        {
            RuleSet("Del", () =>
            {
                RuleFor(t => t.ColumnID).NotNull().GreaterThan(0);
            });

            RuleSet("Update", () =>
            {
                RuleFor(t => t.ColumnID).NotNull().GreaterThan(0);
                RuleFor(t => t.ColumnName).NotNull().NotEmpty();
            });

            RuleSet("Add", () =>
            {
                RuleFor(t => t.AssessID).NotNull().GreaterThan(0);
                RuleFor(t => t.ParentID).NotNull().GreaterThan(-1);
                RuleFor(t => t.ColumnName).NotNull().NotEmpty();
            });

            RuleSet("List", () =>
            {
                RuleFor(t => t.AssessID).NotNull().GreaterThan(0);
            });
        }
    }
}
