﻿using System;
using System.Collections.Generic;

namespace Performance.DtoModels
{
    public class SecondWorkLoadDto
    {
        public SecondWorkLoadDto(string name)
        {
            Name = name;
            Unit_Price = 0m;
            Items = new List<string>();

            AssessmentScore = $"AssessmentScore_{Name}";
            WorkPerformance = $"WorkPerformance_{Name}";
            WorkloadScore = $"WorkloadScore_{Name}";
        }

        public string AssessmentScore { get; set; }
        public string WorkPerformance { get; set; }
        public string WorkloadScore { get; set; }
        public decimal Unit_Price { get; set; }
        public List<string> Items { get; set; }
        public string Name { get; set; }

        public void AddItem(string name)
        {
            if (!Items.Contains(name))
                Items.Add(name);
        }
    }
}
