//-----------------------------------------------------------------------
// <copyright file=" sys_extract.cs">
// * FileName: 医院数据提取脚本.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 医院数据提取脚本
    /// </summary>
    [Table("sys_extract")]
    public class sys_extract
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary>
        public Nullable<int> HospitalId { get; set; }

        /// <summary>
        /// 连接地址
        /// </summary>
        public Nullable<int> ConfigId { get; set; }

        /// <summary>
        /// EXCEL中SHEET名称
        /// </summary>
        public string SheetName { get; set; }

        /// <summary>
        /// 执行脚本
        /// </summary>
        public string ExecuteScript { get; set; }

        /// <summary>
        /// 是否可用 1 可用 2 不可用
        /// </summary>
        public Nullable<int> IsEnable { get; set; }
    }
}
