//-----------------------------------------------------------------------
// <copyright file=" mod_extract.cs">
// * FileName: 医院数据提取脚本.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 医院数据提取脚本
    /// </summary>
    [Table("mod_extract")]
	public class mod_extract
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int Id { get; set; }
    
        /// <summary>
        /// 医院ID
        /// </summary>
        public Nullable<int> HospitalId { get; set; }
    
        /// <summary>
        /// 当前脚本提取内容名称
        /// </summary>
        public string EName { get; set; }
    
        /// <summary>
        /// 执行脚本
        /// </summary>
        public string ExecuteScript { get; set; }
    
        /// <summary>
        /// 当前脚本类型 1 收入整表  2 单项数据提取
        /// </summary>
        public Nullable<int> ExecuteType { get; set; }
    
        /// <summary>
        /// 数据库来源类型 1 标准库 2 绩效库
        /// </summary>
        public Nullable<int> SourceType { get; set; }
    
        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }
    
        /// <summary>
        /// 是否可用 1 可用 2 不可用
        /// </summary>
        public Nullable<int> IsEnable { get; set; }
    
        /// <summary>
        /// 数据库地址
        /// </summary>
        public int ConfigId { get; set; }
    }
}
