﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;

namespace Performance.Services
{
    public class PerSheetDataReadClinicEmployee : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                PerDataClinicEmployee clinicEmployee = new PerDataClinicEmployee
                {
                    RowNumber = r,
                    UnitType = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元分类").PointCell)?.StringCellValue,
                    AccountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.StringCellValue,
                    Department = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.StringCellValue,
                    PersonnelNumber = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "人员工号").PointCell)?.StringCellValue,
                    DoctorName = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医生姓名").PointCell)?.StringCellValue,
                    JobTitle = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "职称").PointCell)?.StringCellValue,
                    PostCoefficient = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "岗位系数").PointCell)?.NumericCellValue),
                    Efficiency = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "效率绩效系数").PointCell)?.NumericCellValue),
                    Scale = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "规模绩效系数").PointCell)?.NumericCellValue),
                    Management = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "管理绩效发放系数").PointCell)?.NumericCellValue),
                    ScoreAverageRate = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell)?.NumericCellValue),
                    Attendance = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "出勤率").PointCell)?.NumericCellValue),
                    OthePerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效").PointCell)?.NumericCellValue),
                    Punishment = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell)?.NumericCellValue),
                    Adjust = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell)?.NumericCellValue),
                };
                if (!string.IsNullOrEmpty(clinicEmployee.UnitType) && !string.IsNullOrEmpty(clinicEmployee.DoctorName))
                    dataList.Add(clinicEmployee);
            }

            return dataList;
        }
    }
}
