﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 人员读取
    /// </summary>
    public class PerSheetDataReadEmployee : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                PerDataEmployee employee = new PerDataEmployee
                {
                    RowNumber = r,
                    AccountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.StringCellValue,
                    Department = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.StringCellValue,
                    PersonnelNumber = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "人员工号").PointCell)?.StringCellValue,
                    DoctorName = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医生姓名").PointCell)?.StringCellValue,
                    JobTitle = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "职称").PointCell)?.StringCellValue,
                    FitPeople = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "绩效基数核算参考对象").PointCell)?.StringCellValue,
                    FitPeopleRatio = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "绩效基数核算系数").PointCell)?.NumericCellValue),
                    AccountType = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "人员分类").PointCell)?.StringCellValue,
                    PostCoefficient = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "岗位系数").PointCell)?.NumericCellValue),
                    WorkTime = NopiSevice.GetCellDatetimeValue(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "参加工作时间").PointCell)),
                    ScoreAverageRate = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell)?.NumericCellValue),
                    Attendance = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "出勤率").PointCell)?.NumericCellValue),
                    //PeopleNumber = ConvertHelper.To<int?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元医生数").PointCell)?.ToString()),
                    //Workload = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "工作量绩效").PointCell)?.ToString()),
                    OthePerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效").PointCell)?.NumericCellValue),
                    Punishment = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell)?.NumericCellValue),
                    Adjust = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell)?.NumericCellValue),
                    //Grant = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "发放系数").PointCell)?.ToString()),
                };
                if (!string.IsNullOrEmpty(employee.AccountingUnit) && !string.IsNullOrEmpty(employee.FitPeople))
                    dataList.Add(employee);
            }

            return dataList;
        }
    }
}
