﻿using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Options;
using Performance.Infrastructure;
using Performance.Services;
using Performance.Services.Queues;
using System;

namespace Performance.Api.Configurations
{
    public static class DependencyInjectionConfig
    {
        public static void AddDependencyInjectionConfiguration(this IServiceCollection services)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            services.AddSingleton<IHttpContextAccessor, HttpContextAccessor>();

            #region custom util

            //huyi短信发送注入
            services.AddScoped<HuyiSmsNotify>();
            //用户身份信息服务
            services.AddScoped<ClaimService>();

            #endregion custom util

            #region email

            //阿里邮箱配置
            var emailOption = services.BuildServiceProvider().GetService<IOptions<EmailOptions>>();
            //邮件发送
            services.AddEmailUtil(options =>
            {
                options.Account = emailOption.Value.Account;
                options.Password = emailOption.Value.Password;
                options.SmtpServer = emailOption.Value.SmtpServer;
            });

            #endregion email

            #region redis

            //var csredis = new CSRedis.CSRedisClient(connection.Value.RedisConnectionString);
            //RedisHelper.Initialization(csredis);

            #endregion redis

            services.AddHostedService<QueuedHostedService>();
            services.AddSingleton<IBackgroundTaskQueue, BackgroundTaskQueue>();
            services.AddSingleton<IHubNotificationQueue, HubNotificationQueue>();

            services
                .AddPerformanceService()
                .AddPerformanceRepoitory();
        }
    }
}
