﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerDataAccountBaisc : IPerData
    {
        /// <summary>
        /// 行号
        /// </summary>
        public int RowNumber { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        #region EXCEL读取

        /// <summary>
        /// 核算单元类别 1 医生组 2护理组 3医技组
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元 
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 定科人数
        /// </summary>
        public decimal PermanentStaff { get; set; }

        /// <summary>
        /// 科主任/护士长数量
        /// </summary>
        public decimal ManagerNumber { get; set; }

        /// <summary>
        /// 核算单元医生数量
        /// </summary>
        public decimal Number { get; set; }

        /// <summary>
        /// 医生基础系数
        /// </summary>
        public decimal BasicFactor { get; set; }

        /// <summary>
        /// 倾斜系数
        /// </summary>
        public decimal SlopeFactor { get; set; }

        /// <summary>
        /// 其他绩效1
        /// </summary>
        public decimal OtherPerfor1 { get; set; }

        /// <summary>
        /// 其他绩效2
        /// </summary>
        public decimal OtherPerfor2 { get; set; }

        /// <summary>
        /// 药占比奖罚
        /// </summary>
        public decimal MedicineExtra { get; set; }

        /// <summary>
        /// 材料占比奖罚
        /// </summary>
        public decimal MaterialsExtra { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public decimal Extra { get; set; }

        /// <summary>
        /// 考核对分率
        /// </summary>
        public decimal ScoringAverage { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public decimal AdjustFactor { get; set; }

        /// <summary>
        /// 规模绩效系数
        /// </summary>
        public decimal Scale { get; set; }

        /// <summary>
        /// 效率绩效系数
        /// </summary>
        public decimal Effic { get; set; }

        /// <summary>
        /// 发放系数
        /// </summary>
        public decimal Grant { get; set; }

        /// <summary>
        /// 保底绩效参考标准
        /// </summary>
        public string MinimumReference { get; set; }

        /// <summary>
        /// 保底绩效系数
        /// </summary>
        public Nullable<decimal> MinimumFactor { get; set; }

        /// <summary>
        /// 工作量倾斜系数
        /// </summary>
        public Nullable<decimal> WorkSlopeFactor { get; set; }
        #endregion


        #region 由计算得出
        /// <summary>
        /// 保底绩效金额
        /// </summary>
        public Nullable<decimal> MinimumFee { get; set; }

        /// <summary>
        /// 科室业绩
        /// </summary>
        public Nullable<decimal> Income { get; set; }

        /// <summary>
        /// 业绩绩效
        /// </summary>
        public Nullable<decimal> PerforFee { get; set; }

        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> WorkloadFee { get; set; }

        /// <summary>
        /// 绩效合计
        /// </summary>
        public Nullable<decimal> PerforTotal { get; set; }

        /// <summary>
        /// 人均绩效
        /// </summary>
        public Nullable<decimal> Avg { get; set; }

        /// <summary>
        /// 实发绩效
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }

        #endregion
    }
}
