//-----------------------------------------------------------------------
// <copyright file=" per_budget_result.cs">
// * FileName: 预算控制年度合计.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 预算控制年度合计
    /// </summary>
    [Table("per_budget_result")]
	public class per_budget_result
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int Id { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public int HospitalId { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public int Year { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public int Month { get; set; }
    
        /// <summary>
        /// 绩效可发比例
        /// </summary>
        public Nullable<decimal> Grant { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }
    
        /// <summary>
        /// 医疗收入
        /// </summary>
        public Nullable<decimal> MedicalIncome { get; set; }
    
        /// <summary>
        /// 人员经费
        /// </summary>
        public Nullable<decimal> PersonnelExpenditure { get; set; }
    
        /// <summary>
        /// 新绩效
        /// </summary>
        public Nullable<decimal> TheNewPerformance { get; set; }
    
        /// <summary>
        /// 药占比（收入）
        /// </summary>
        public Nullable<decimal> MedicineProportion { get; set; }
    
        /// <summary>
        /// 材料支出
        /// </summary>
        public Nullable<decimal> MaterialCosts { get; set; }
    
        /// <summary>
        /// 药材比例合计
        /// </summary>
        public Nullable<decimal> TotalMedicine { get; set; }
    
        /// <summary>
        /// 固定资产折旧
        /// </summary>
        public Nullable<decimal> DepreOfFixedAssets { get; set; }
    
        /// <summary>
        /// 其他
        /// </summary>
        public Nullable<decimal> OtherExpenses { get; set; }
    
        /// <summary>
        /// 人+药+材的支出比例
        /// </summary>
        public Nullable<decimal> TheCostInTotal { get; set; }
    
        /// <summary>
        /// 成本合计
        /// </summary>
        public Nullable<decimal> TheCostCombined { get; set; }
    
        /// <summary>
        /// 人员经费实际比例
        /// </summary>
        public Nullable<decimal> PersonExpendRatio { get; set; }
    
        /// <summary>
        /// 新绩效实际比例
        /// </summary>
        public Nullable<decimal> NewPerformanceRatio { get; set; }
    
        /// <summary>
        /// 药占比实际比例
        /// </summary>
        public Nullable<decimal> MedicinePropRatio { get; set; }
    
        /// <summary>
        /// 材料支出实际比例
        /// </summary>
        public Nullable<decimal> MaterialCostsRatio { get; set; }
    
        /// <summary>
        /// 药材合计实际比例
        /// </summary>
        public Nullable<decimal> TotalMedicineRatio { get; set; }
    
        /// <summary>
        /// 固定资产折旧实际比例
        /// </summary>
        public Nullable<decimal> DepreOfFixedAssetsRatio { get; set; }
    
        /// <summary>
        /// 其他费用实际比例
        /// </summary>
        public Nullable<decimal> OtherExpensesRatio { get; set; }
    
        /// <summary>
        /// 人+药+材的支出实际比例
        /// </summary>
        public Nullable<decimal> TheCostInTotalRatio { get; set; }
    
        /// <summary>
        /// 成本合计实际比例
        /// </summary>
        public Nullable<decimal> TheCostCombinedRatio { get; set; }
    
        /// <summary>
        /// 人员经费（不含绩效）
        /// </summary>
        public Nullable<decimal> NoPerformanceExpenditure { get; set; }
    
        /// <summary>
        /// 人员经费（不含绩效）实际比例
        /// </summary>
        public Nullable<decimal> NoPerformanceExpenditureRatio { get; set; }
    
        /// <summary>
        /// 1.初始 2. 确认使用发放/调节系数
        /// </summary>
        public int States { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> CreateDate { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }
    }
}
