﻿//-----------------------------------------------------------------------
// <copyright file=" cof_director.cs">
// * FileName: cof_director.cs
// * history : Created by T4 2019-03-22 15:48:55 
// </copyright>
//-----------------------------------------------------------------------
using Dapper;
using Microsoft.EntityFrameworkCore;
using Performance.EntityModels;
using System;
using System.Collections.Generic;

namespace Performance.Repository
{
    /// <summary>
    /// cof_director Repository
    /// </summary>
    public partial class PerforCofdirectorRepository : PerforRepository<cof_director>
    {
        public int DeleteData(int allotId)
        {
            List<string> tableArray = new List<string>
            {
                "im_accountbasic",
                "im_data",
                "im_employee",
                "im_employee_clinic",
                "im_header",
                "im_specialunit",
                "per_sheet",
                "res_account",
                "res_accountdoctor",
                "res_accountnurse",
                "res_baiscnorm",
                "res_compute",
                "res_specialunit",
                "log_check",
                "log_dbug",
            };
            string sql = "";
            tableArray.ForEach(t => sql += $"delete from {t} where allotid=@allotId;");

            return Execute(sql, new { allotId });
        }

        public int DeleteResData(int allotId)
        {
            List<string> tableArray = new List<string>
            {
                "res_account",
                "res_accountdoctor",
                "res_accountnurse",
                "res_baiscnorm",
                "res_compute",
                "res_specialunit",
                "log_dbug",
            };
            string sql = "";
            tableArray.ForEach(t => sql += $"delete from {t} where allotid=@allotId;");
            sql += "delete from per_sheet where allotid=@allotId and source=2;";

            return Execute(sql, new { allotId });
        }

        public int DelAgain(int againid)
        {
            List<string> tableArray = new List<string>
            {
                "ag_data",
                "ag_employee",
                "ag_header",
                "ag_againsituation"
            };
            string sql = "";
            tableArray.ForEach(t => sql += $"delete from {t} where againallotid=@againid;");

            return Execute(sql, new { againid });
        }

        /// <summary>
        /// 补充费用占比类型
        /// </summary>
        /// <param name="allotid"></param>
        /// <returns></returns>
        public int SupplementaryData(int allotid)
        {
            using (var connection = context.Database.GetDbConnection())
            {
                var sql = @"insert into cof_drugtype(allotid,charge) select 
distinct @allotid allotid,typename charge
from per_sheet sheet 
	inner join im_data im on sheet.id = im.sheetid 
	left join cof_drugtype dtype on sheet.allotid = dtype.allotid 
		and im.typename != dtype.charge
where sheet.allotid = @allotid and sheet.sheettype = 3 and im.typename not in 
	(select charge from cof_drugtype where allotid = @allotid);

insert into cof_depttype(allotid,charge) select 
distinct @allotid allotid,department charge
from per_sheet sheet 
	inner join im_data im on sheet.id = im.sheetid 
	left join cof_depttype dtype on sheet.allotid = dtype.allotid 
		and im.department != dtype.charge
where sheet.allotid = @allotid and sheet.sheettype = 9 and im.department not in 
	(select charge from cof_depttype where allotid = @allotid);";

                return connection.Execute(sql, new { allotid }, commandTimeout: 60 * 60);
            }
        }
    }
}
