﻿using NPOI.HSSF.UserModel;
using NPOI.HSSF.Util;
using NPOI.SS.UserModel;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services
{
    public enum StyleType
    {
        //列头固定,
        列头,
        系数,
        数据,
        默认,
    }
    public enum CellFormat
    {
        数字,
        数字2,
        百分比,
        百分比2,
        时间,
        默认,
    }

    public class CellStyle
    {
        public static ICellStyle CreateCellStyle(IWorkbook wb, StyleType type = StyleType.默认, CellFormat format = CellFormat.默认)
        {
            ICellStyle cellStyle = wb.CreateCellStyle();

            //字体
            IFont font = wb.CreateFont();
            font.FontHeightInPoints = 11;
            font.FontName = "微软雅黑";
            font.Color = HSSFColor.Black.Index;

            //边框
            cellStyle.BorderBottom = BorderStyle.Thin;
            cellStyle.BorderLeft = BorderStyle.Thin;
            cellStyle.BorderRight = BorderStyle.Thin;
            cellStyle.BorderTop = BorderStyle.Thin;

            //边框颜色  
            cellStyle.BottomBorderColor = HSSFColor.Black.Index;
            cellStyle.TopBorderColor = HSSFColor.Black.Index;
            cellStyle.LeftBorderColor = HSSFColor.Black.Index;
            cellStyle.RightBorderColor = HSSFColor.Black.Index;

            cellStyle.SetFont(font);

            //居中
            cellStyle.Alignment = HorizontalAlignment.Center;//水平居中
            cellStyle.VerticalAlignment = VerticalAlignment.Center;//垂直居中

            switch (type)
            {
                case StyleType.列头:
                    cellStyle.FillForegroundColor = HSSFColor.Gold.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.系数:
                    cellStyle.FillForegroundColor = HSSFColor.Green.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.数据:
                    cellStyle.FillForegroundColor = HSSFColor.SkyBlue.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.默认:
                    cellStyle.SetFont(font);
                    break;
            }
            IDataFormat datastyle = wb.CreateDataFormat();
            switch (format)
            {
                case CellFormat.时间:
                    cellStyle.DataFormat = datastyle.GetFormat("yyyy/mm/dd");
                    break;
                case CellFormat.数字:
                    cellStyle.DataFormat = datastyle.GetFormat("0");
                    break;
                case CellFormat.数字2:
                    cellStyle.DataFormat = datastyle.GetFormat("0.00");
                    break;
                case CellFormat.百分比:
                    cellStyle.DataFormat = datastyle.GetFormat("0%");
                    break;
                case CellFormat.百分比2:
                    cellStyle.DataFormat = datastyle.GetFormat("0.00%");
                    break;
                case CellFormat.默认:
                    cellStyle.SetFont(font);
                    break;
            }
            return cellStyle;

        }
    }
}
