﻿using Microsoft.AspNetCore.Mvc.ViewFeatures;
using Microsoft.AspNetCore.SignalR;
using Microsoft.Extensions.Logging;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services
{
    public class LogManageService : IAutoInjection
    {
        private readonly ILogger<LogManageService> logger;
        private readonly IHubContext<AllotLogHub> hubContext;
        private PerforLogdbugRepository logdbug;
        public LogManageService(
            ILogger<LogManageService> logger,
            IHubContext<AllotLogHub> hubContext,
            PerforLogdbugRepository logdbug)
        {
            this.logger = logger;
            this.hubContext = hubContext;
            this.logdbug = logdbug;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="tag">标签</param>
        /// <param name="message">内容</param>
        /// <param name="level">等级1、信息（info）2、警告（warn）3、错误（error）4、异常（exception）5、成功（success）</param>
        /// <param name="allotId">绩效Id</param>
        /// <param name="method">方法名称</param>
        public void WriteMsg(string tag, string message, int level, int allotId, string method, bool isDebug = false)
        {
            logger.LogInformation($"method:{method};tag:{tag}; message:{message}; level:{level}");
            hubContext.Clients.Group(allotId.ToString()).SendAsync(method, tag, message, level);
            if (isDebug)
            {
                logdbug.Add(allotId, tag, message, level);
            }
        }
    }
}
