﻿using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 工厂
    /// </summary>
    public class PerSheetDataFactory
    {
        /// <summary>
        /// 构建excel读取
        /// </summary>
        /// <param name="sheetType"></param>
        /// <returns></returns>
        public static IPerSheetDataRead GetDataRead(SheetType sheetType, bool isnew = false)
        {
            IPerSheetDataRead dataread = null;
            switch (sheetType)
            {
                case SheetType.Employee:
                    dataread = new PerSheetDataReadEmployee();
                    break;
                case SheetType.ClinicEmployee:
                    dataread = new PerSheetDataReadClinicEmployee();
                    break;
                case SheetType.Income:
                    if (isnew)
                        dataread = new PerSheetDataReadBillIncome();
                    else
                        dataread = new PerSheetDataReadIncome();
                    break;
                case SheetType.OtherIncome:
                    dataread = new PerSheetDataReadOtherIncome();
                    break;
                case SheetType.Expend:
                    dataread = new PerSheetDataReadExpend();
                    break;
                //case SheetType.Overtime:
                //    dataread = new PerSheetDataReadOvertime();
                //    break;
                case SheetType.Workload:
                    dataread = new PerSheetDataReadWorkload();
                    break;
                case SheetType.AccountBasic:
                    dataread = new PerSheetDataReadDeptAccounting();
                    break;
                case SheetType.SpecialUnit:
                    dataread = new PerSheetDataReadSpecialUnit();
                    break;
                case SheetType.AccountBasicSpecial:
                    dataread = new PerSheetDataReadDeptAccountingSpecial();
                    break;
            }
            return dataread;
        }
    }
}
