﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class PerSheetDataReadClinicEmployee : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();
            string[] headers = new string[]
            {
                "核算单元分类",
                "核算单元",
                "核算单元",
                "人员工号",
                "医生姓名",
                "职务分类",
                "基础绩效系数",
                "岗位系数",
                "效率绩效系数",
                "规模绩效系数",
                "管理绩效发放系数",
                "考核得分率",
                "出勤率",
                "其他绩效",
                "医院奖罚",
                "调节系数",
            };
            foreach (var item in headers)
            {
                if (!perHeader.Any(p => p.CellValue == item))
                    throw new NullReferenceException($"sheet '{sheet.SheetName}'中列'{item}'为空");
            }
            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                PerDataClinicEmployee clinicEmployee = new PerDataClinicEmployee
                {
                    RowNumber = r,
                    UnitType = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元分类").PointCell)?.StringCellValue,
                    AccountingUnit = NopiSevice.GetCellStringValue(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)),
                    Department = NopiSevice.GetCellStringValue(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)),
                    PersonnelNumber = NopiSevice.GetCellStringValue(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "人员工号").PointCell)),
                    DoctorName = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医生姓名").PointCell)?.StringCellValue,
                    JobTitle = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "职务分类").PointCell)?.StringCellValue,
                    Basics = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "基础绩效系数").PointCell)?.NumericCellValue),
                    PostCoefficient = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "岗位系数").PointCell)?.NumericCellValue),
                    Efficiency = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "效率绩效系数").PointCell)?.NumericCellValue),
                    Scale = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "规模绩效系数").PointCell)?.NumericCellValue),
                    Management = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "管理绩效发放系数").PointCell)?.NumericCellValue),
                    ScoreAverageRate = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell)?.NumericCellValue),
                    Attendance = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "出勤率").PointCell)?.NumericCellValue),
                    OthePerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效").PointCell)?.NumericCellValue),
                    Punishment = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell)?.NumericCellValue),
                    Adjust = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell)?.NumericCellValue),
                };
                if (!string.IsNullOrEmpty(clinicEmployee.UnitType) && !string.IsNullOrEmpty(clinicEmployee.DoctorName))
                    dataList.Add(clinicEmployee);
            }

            return dataList;
        }
    }
}
