﻿using System;
using System.Collections.Generic;
using System.Text;
using FluentValidation;

namespace Performance.DtoModels.Request
{
    public class ComputerAvgRequest
    {
        public int Id { get; set; }
        public int AllotId { get; set; }
        public int SheetId { get; set; }
        /// <summary>
        /// 绩效核算人群
        /// </summary>
        public string PositionName { get; set; }
        /// <summary>
        /// 绩效总额
        /// </summary>
        public decimal TotelValue { get; set; }
        /// <summary>
        /// 人均绩效
        /// </summary>
        public decimal AvgValue { get; set; }
        /// <summary>
        /// 总人数
        /// </summary>
        public decimal TotelNumber { get; set; }
    }
    public class ComputerRequestValidator : AbstractValidator<ComputerAvgRequest>
    {
        public ComputerRequestValidator()
        {
            RuleFor(x => x.Id).NotNull();
            RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
            RuleFor(x => x.PositionName).NotNull().NotEmpty();
            RuleFor(x => x.TotelNumber).NotNull();
            RuleFor(x => x.TotelValue).NotNull();
            RuleFor(x => x.AvgValue).NotNull();
        }
    }
}
