﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerDataClinicEmployee : IPerData
    {
        /// <summary>
        /// 核算单元分类
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 人员工号
        /// </summary>
        public string PersonnelNumber { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 职务分类
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 基础绩效系数
        /// </summary>
        public Nullable<decimal> Basics { get; set; }

        /// <summary>
        /// 效率绩效人数
        /// </summary>
        public decimal PermanentStaff { get; set; }

        ///// <summary>
        ///// 岗位系数
        ///// </summary>
        //public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 效率绩效系数
        /// </summary>
        public Nullable<decimal> Efficiency { get; set; }

        /// <summary>
        /// 规模绩效系数
        /// </summary>
        public Nullable<decimal> Scale { get; set; }

        /// <summary>
        /// 管理绩效发放系数
        /// </summary>
        public Nullable<decimal> Management { get; set; }

        ///// <summary>
        ///// 参加工作时间
        ///// </summary>
        //public Nullable<DateTime> WorkTime { get; set; }

        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }

        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 其他管理绩效
        /// </summary>
        public Nullable<decimal> OtheManagementPerfor { get; set; }

        ///// <summary>
        ///// 其他绩效
        ///// </summary>
        //public Nullable<decimal> OthePerfor { get; set; }

        ///// <summary>
        ///// 医院奖罚
        ///// </summary>
        //public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }

        /// <summary>
        /// 行号
        /// </summary>
        public int RowNumber { get; set; }
    }
}
