﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Performance.DtoModels
{
    public class UserRequest
    {
        public int ID { get; set; }
        /// <summary>
        /// 真实名称
        /// </summary>
        public string RealName { get; set; }
        /// <summary>
        /// 手机号
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// 登录名称
        /// </summary>
        public string Login { get; set; }

        /// <summary>
        /// 密码
        /// </summary>
        public string Password { get; set; }

        /// <summary>
        /// 邮箱
        /// </summary>
        public string Mail { get; set; }

        /// <summary>
        /// 用户状态 1启用 2禁用
        /// </summary>
        public Nullable<int> States { get; set; }

        /// <summary>
        /// 角色
        /// </summary>
        public int Role { get; set; }

        /// <summary>
        /// 用户医院ID
        /// </summary>
        public int[] HosIDArray { get; set; }

        /// <summary>
        /// 用户科室
        /// </summary>
        public string Department { get; set; }
    }

    public class UserRequestValidator : AbstractValidator<UserRequest>
    {
        public UserRequestValidator()
        {
            Action action = () =>
            {
                RuleFor(x => x.RealName).NotNull().NotEmpty();
                RuleFor(x => x.Login).NotNull().NotEmpty();
                //RuleFor(x => x.Mobile).NotNull().NotEmpty().Must((pre) => { return CustomValidator.IsMobile(pre); });
                //RuleFor(x => x.Mail).EmailAddress().When(pre => { return !string.IsNullOrEmpty(pre.Mail); });
            };

            RuleSet("Insert", () =>
            {
                action();
                RuleFor(x => x.Role).NotNull().NotEmpty().GreaterThan(0);
                RuleFor(x => x.Password).NotNull().NotEmpty().Length(4, 20);
                RuleFor(x => x.HosIDArray).NotNull().NotEmpty().Must(f => f.Length > 0);
            });

            RuleSet("Update", () =>
            {
                action();
                RuleFor(x => x.ID).NotNull().NotEmpty().GreaterThan(0);
                RuleFor(x => x.States).InclusiveBetween(1, 2);
                RuleFor(x => x.Password).Length(4, 20);
                RuleFor(x => x.Role).NotNull().NotEmpty().GreaterThan(0);
                RuleFor(x => x.HosIDArray).NotNull().NotEmpty().Must(f => f.Length > 0);
            });

            RuleSet("Delete", () =>
            {
                RuleFor(x => x.ID).NotNull().NotEmpty().GreaterThan(0);
            });

            RuleSet("Self", () =>
            {
                RuleFor(x => x.Password).Length(4, 20);
                //RuleFor(x => x.Mobile).Must((pre) =>
                //{
                //    if (!string.IsNullOrEmpty(pre))
                //        return CustomValidator.IsMobile(pre);
                //    return true;
                //});
                //RuleFor(x => x.Mail).EmailAddress().When(pre => { return !string.IsNullOrEmpty(pre.Mail); });
            });
        }
    }
}
