﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class WorkDetailRequest
    {
        public int AllotId { get; set; }

        public string AccountingUnit { get; set; }
    }

    public class WorkDetailRequestValidator : AbstractValidator<WorkDetailRequest>
    {
        public WorkDetailRequestValidator()
        {
            RuleSet("Select", () =>
            {
                RuleFor(x => x.AllotId).NotNull().NotEmpty().GreaterThan(0);
                RuleFor(x => x.AccountingUnit).NotNull().NotEmpty();
            });
        }
    }
}
