﻿using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class SelectionOptions
    {
        public SelectionOptions(rep_selection item)
        {
            SelectionID = item.ID;
            Title = item.Title;
            InputType = item.InputType;
            InputName = item.InputName;
            Required = item.Required ?? 0;
            Sort = item.Sort ?? 0m;
            LoadType = item.LoadType;
            DefaultValue = item.DefaultValue;
            Options = new List<TitleValue>();
            ParentItems = new List<TitleValue>();
        }
        /// <summary>
        /// ID
        /// </summary>
        public int SelectionID { get; }
        /// <summary>
        /// 排序
        /// </summary>
        public decimal Sort { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 类型 
        /// </summary>
        public string InputType { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string InputName { get; set; }

        /// <summary>
        /// 父控件名称
        /// </summary>
        public int ParentID { get; set; }

        /// <summary>
        /// 父控件名称
        /// </summary>
        public string ParentName { get; set; }

        public List<TitleValue> ParentItems { get; set; }

        /// <summary>
        /// 控件数据加载方式 1 立即加载 2 联动加载 3 自动补全
        /// </summary>
        public int LoadType { get; set; }

        /// <summary>
        /// 是否必填
        /// </summary>
        public int Required { get; set; }

        /// <summary>
        /// 默认值
        /// </summary>
        public string DefaultValue { get; set; }

        /// <summary>
        /// 数据集合
        /// </summary>
        public List<TitleValue> Options { get; set; }
    }
}
