﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Performance.DtoModels;
using Performance.Infrastructure;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Extract.Api.Controllers
{
    [Route("api/[controller]")]
    public class ModExtractController : Controller
    {
        private readonly ILogger<ModExtractController> logger;
        private ExConfigService service;
        public ModExtractController(
            ILogger<ModExtractController> logger,
           ExConfigService service)
        {
            this.logger = logger;
            this.service = service;
        }

        /// <summary>
        /// 绩效数据抽取模板
        /// </summary>
        /// <returns></returns>
        [Route("scheme")]
        [HttpPost]
        public ApiResponse Extract([CustomizeValidator(RuleSet = "Query"), FromBody]ModModuleRequest request)
        {
            if (request.HospitalId == null || request.HospitalId.Value == 0)
                return new ApiResponse(ResponseType.ParameterError, "HospitalId 不存在，请重新选择！");
            if (request.ExecuteType == null || !request.ExecuteType.Any())
                return new ApiResponse(ResponseType.ParameterError, "ExecuteType 不存在，请重新选择！");

            var list = service.ExtractScheme(request.HospitalId.Value, request.ExecuteType);
            return new ApiResponse(ResponseType.OK, list);
        }

        /// <summary>
        /// 费用类型
        /// </summary>
        /// <returns></returns>
        [Route("type")]
        [HttpPost]
        public ApiResponse FeeType()
        {
            var list = service.FeeType();
            return new ApiResponse(ResponseType.OK, list);
        }

        /// <summary>
        /// 绩效考核项费用来源
        /// </summary>
        /// <returns></returns>
        [Route("source")]
        [HttpPost]
        public ApiResponse FeeSource([FromBody]ModModuleRequest request)
        {
            if (request.HospitalId == null || request.HospitalId.Value == 0)
                return new ApiResponse(ResponseType.ParameterError, "HospitalId 参数错误！");

            logger.LogInformation($"请求参数绩效考核项费用来源：{JsonHelper.Serialize(request)}");
            var list = service.FeeSource(request);
            return new ApiResponse(ResponseType.OK, list);
        }

        /// <summary>
        /// 绩效收入模板配置项列表
        /// </summary>
        /// <returns></returns>
        [Route("items")]
        [HttpPost]
        public ApiResponse Items([FromBody]ModItemRequest request)
        {
            logger.LogInformation($"绩效收入模板配置项列表：{JsonHelper.Serialize(request)}");
            service.AddItems(request.ModuleId.Value);
            return new ApiResponse(ResponseType.OK);
        }
    }
}