﻿using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services
{
    public class ExcelReadConfig
    {
        public static ColumnInfo[] Employee { get; set; } = new ColumnInfo[]
        {
            new ColumnInfo(nameof(PerDataEmployee.AccountingUnit), "核算单元" ),
            new ColumnInfo(nameof(PerDataEmployee.Department), "核算单元"),
            new ColumnInfo(nameof(PerDataEmployee.PersonnelNumber), "人员工号"),
            new ColumnInfo(nameof(PerDataEmployee.DoctorName), "医生姓名"),
            new ColumnInfo(nameof(PerDataEmployee.JobTitle), "职务分类"),
            new ColumnInfo(nameof(PerDataEmployee.FitPeople), "绩效基数核算参考对象"),
            new ColumnInfo(nameof(PerDataEmployee.FitPeopleValue), "绩效基础核算参考值", true),
            new ColumnInfo(nameof(PerDataEmployee.FitPeopleRatio), "绩效基数核算系数", true),
            new ColumnInfo(nameof(PerDataEmployee.AccountType), "人员分类"),
            new ColumnInfo(nameof(PerDataEmployee.PostCoefficient), "岗位系数", true),
            new ColumnInfo(nameof(PerDataEmployee.ScoreAverageRate), "考核得分率", true),
            new ColumnInfo(nameof(PerDataEmployee.Attendance), "出勤率", true),
            new ColumnInfo(nameof(PerDataEmployee.Adjust), "调节系数", true),
        };


        public static ColumnInfo[] ClinicEmployee { get; set; } = new ColumnInfo[]
        {
            new ColumnInfo(nameof(PerDataClinicEmployee.UnitType),  "核算单元分类"),
            new ColumnInfo(nameof(PerDataClinicEmployee.AccountingUnit), "核算单元"),
            new ColumnInfo(nameof(PerDataClinicEmployee.Department), "核算单元"),
            new ColumnInfo(nameof(PerDataClinicEmployee.PersonnelNumber), "人员工号"),
            new ColumnInfo(nameof(PerDataClinicEmployee.DoctorName), "医生姓名"),
            new ColumnInfo(nameof(PerDataClinicEmployee.JobTitle), "职务分类"),
            new ColumnInfo(nameof(PerDataClinicEmployee.Basics), "基础绩效系数", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.PermanentStaff), "效率绩效人数", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.Efficiency), "效率绩效系数", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.Scale), "规模绩效系数", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.Management), "管理绩效发放系数", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.ScoreAverageRate), "考核得分率", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.Attendance), "出勤率", true),
            new ColumnInfo(nameof(PerDataClinicEmployee.OtheManagementPerfor), "其他管理绩效"),
            new ColumnInfo(nameof(PerDataClinicEmployee.Adjust), "调节系数", true),
        };


        public static ColumnInfo[] LogisticsEmployee { get; set; } = new ColumnInfo[]
        {
            new ColumnInfo(nameof(PerDataLogisticsEmployee.AccountType), "人员分类"),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.AccountingUnit), "核算单元"),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.FitPeople), "绩效基数核算参考对象"),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.FitPeopleValue), "绩效基础核算参考值", true),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.FitPeopleRatio), "绩效基数核算系数", true),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.JobNumber), "人员工号"),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.DoctorName), "人员姓名"),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.JobTitle), "职务分类"),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.PostCoefficient), "岗位系数", true),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.Attendance), "出勤率", true),
            new ColumnInfo(nameof(PerDataLogisticsEmployee.OthePerfor), "其他绩效", true),
        };

        public static ColumnInfo[] AccountBaisc { get; set; } = new ColumnInfo[]
        {
            new ColumnInfo(nameof(PerDataAccountBaisc.UnitType), "核算单元类型"),
            new ColumnInfo(nameof(PerDataAccountBaisc.AccountingUnit), "核算单元"),
            new ColumnInfo(nameof(PerDataAccountBaisc.ManagerNumber), "科主任/护士长人数", true),
            new ColumnInfo(nameof(PerDataAccountBaisc.Number), "核算单元人员数量", true),
            new ColumnInfo(nameof(PerDataAccountBaisc.BasicFactor), "预算比例", true),
            new ColumnInfo(nameof(PerDataAccountBaisc.OtherPerfor1), "其他绩效1", true),
            new ColumnInfo(nameof(PerDataAccountBaisc.ScoringAverage), "考核得分率", true),
            new ColumnInfo(nameof(PerDataAccountBaisc.AdjustFactor), "调节系数", true),
        };
    }

    public class ColumnInfo
    {
        public ColumnInfo(string field, string description, bool isNumber = false)
        {
            Field = field;
            Description = description;
            IsNumber = isNumber;
        }

        public string Field { get; set; }
        public string Description { get; set; }
        public bool IsNumber { get; set; }
    }
}
