﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.Services;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class ReportController : Controller
    {
        private ReportService reportService;
        public ReportController(ReportService reportService)
        {
            this.reportService = reportService;
        }

        /// <summary>
        /// 月群体人均绩效
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("getperforavg")]
        [HttpPost]
        public ApiResponse AvgPerfor([CustomizeValidator(RuleSet = "Query"), FromBody]ReportRequest request)
        {
            var list = reportService.GetAvgPerfor(request.HospitalId);
            return new ApiResponse(ResponseType.OK, "", list);
        }
    }
}