﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerDataAccountBaisc : IPerData
    {
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 核算单元医生数量
        /// </summary>
        public decimal DoctorNumber { get; set; }

        /// <summary>
        /// 医生基础系数
        /// </summary>
        public decimal DoctorBasicFactor { get; set; }

        /// <summary>
        /// 倾斜系数
        /// </summary>
        public decimal DoctorSlopeFactor { get; set; }

        /// <summary>
        /// 其他绩效1
        /// </summary>
        public decimal DoctorOtherPerfor1 { get; set; }

        /// <summary>
        /// 其他绩效2
        /// </summary>
        public decimal DoctorOtherPerfor2 { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public decimal DoctorExtra { get; set; }

        /// <summary>
        /// 考核对分率
        /// </summary>
        public decimal DoctorScoringAverage { get; set; }
        /// <summary>
        /// 调节系数
        /// </summary>
        public decimal DoctorAdjustFactor { get; set; }

        /// <summary>
        /// 核算单元护士数量
        /// </summary>
        public decimal NurseNumber { get; set; }

        /// <summary>
        /// 护理基础系数
        /// </summary>
        public decimal NurseBasicFactor { get; set; }

        /// <summary>
        /// 护理倾斜系数
        /// </summary>
        public decimal NurseSlopeFactor { get; set; }

        /// <summary>
        /// 其他绩效1
        /// </summary>
        public decimal NurseOtherPerfor1 { get; set; }

        /// <summary>
        /// 其他绩效2
        /// </summary>
        public decimal NurseOtherPerfor2 { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public decimal NurseExtra { get; set; }

        /// <summary>
        /// 考核对分率
        /// </summary>
        public decimal NurseScoringAverage { get; set; }
        /// <summary>
        /// 调节系数
        /// </summary>
        public decimal NurseAdjustFactor { get; set; }
        /// <summary>
        /// 行号
        /// </summary>
        public int RowNumber { get; set; }

    }
}
