﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class AssessDataRequest : ApiRequest
    {
        public int AssessID { get; set; }
        public List<AssessRow> AssessRow { get; set; }

    }
    public class AssessRow
    {
        public int DataID { get; set; }
        public string DataValue { get; set; }
    }

    public class AssessDataRequestValidator : AbstractValidator<AssessDataRequest>
    {
        public AssessDataRequestValidator()
        {
            RuleSet("List", () =>
            {
                RuleFor(t => t.AssessID).NotNull().GreaterThan(0);
            });

            RuleSet("Edit", () =>
            {
                RuleFor(t => t.AssessRow).NotNull().Must(p => p != null && p.Count > 0);
            });
        }
    }
}
