﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class IncomeRequest : ApiRequest
    {
        public int ID { get; set; }

        public int AllotID { get; set; }
        /// <summary>
        /// 关键字匹配
        /// </summary>
        public string SheetNameKeyword { get; set; }
        /// <summary>
        /// 分组名称（医生、护理）
        /// </summary>
        public string UnitName { get; set; }
        /// <summary>
        /// 有效收入占比
        /// </summary>
        public decimal Value { get; set; }


        public class IncomeRequestValidator : AbstractValidator<IncomeRequest>
        {
            public IncomeRequestValidator()
            {
                RuleSet("Select", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
                });

                RuleSet("Insert", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().GreaterThan(0);
                });

                RuleSet("Update", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
