﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// 登录请求
    /// </summary>
    public class LoginRequest : ApiRequest
    {
        /// <summary>
        /// 登录类型 1 手机号登录 2 账号登录
        /// </summary>
        public int LoginType { get; set; }
        public string Account { get; set; }
        public string Password { get; set; }
    }

    public class LoginRequestValidator : AbstractValidator<LoginRequest>
    {
        public LoginRequestValidator()
        {
            RuleFor(x => x.LoginType).NotNull().NotEmpty().InclusiveBetween(1, 2);

            RuleFor(x => x.Account).NotEmpty().NotNull().Length(1, 200);

            RuleFor(x => x.Password).NotEmpty().NotNull().Length(1, 200);
        }
    }
}
