﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ReportRequest : ApiRequest
    {
        public int HospitalId { get; set; }
    }
    public class ReportRequestValidator : AbstractValidator<ReportRequest>
    {
        public ReportRequestValidator()
        {
            RuleSet("Query", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
            });
        }
    }
}
