//-----------------------------------------------------------------------
// <copyright file=" im_accountbasic.cs">
// * FileName: 科室核算导入信息.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels	
{
    /// <summary>
    /// 科室核算导入信息
    /// </summary>
    [Table("im_accountbasic")]
	public class im_accountbasic
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> SheetID { get; set; }
    
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    
        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }
    
        /// <summary>
        /// 核算单元医生数量
        /// </summary>
        public Nullable<decimal> DoctorNumber { get; set; }
    
        /// <summary>
        /// 医生基础系数
        /// </summary>
        public Nullable<decimal> DoctorBasicFactor { get; set; }
    
        /// <summary>
        /// 倾斜系数
        /// </summary>
        public Nullable<decimal> DoctorSlopeFactor { get; set; }
    
        /// <summary>
        /// 其他绩效1
        /// </summary>
        public Nullable<decimal> DoctorOtherPerfor1 { get; set; }
    
        /// <summary>
        /// 其他绩效2
        /// </summary>
        public Nullable<decimal> DoctorOtherPerfor2 { get; set; }
    
        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> DoctorExtra { get; set; }
    
        /// <summary>
        /// 考核对分率
        /// </summary>
        public Nullable<decimal> DoctorScoringAverage { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> DoctorAdjustFactor { get; set; }
    
        /// <summary>
        /// 护士人数
        /// </summary>
        public Nullable<int> NurseNumber { get; set; }
    
        /// <summary>
        /// 护理基础系数
        /// </summary>
        public Nullable<decimal> NurseBasicFactor { get; set; }
    
        /// <summary>
        /// 倾斜系数
        /// </summary>
        public Nullable<decimal> NurseSlopeFactor { get; set; }
    
        /// <summary>
        /// 其他绩效1
        /// </summary>
        public Nullable<decimal> NurseOtherPerfor1 { get; set; }
    
        /// <summary>
        /// 其他绩效2
        /// </summary>
        public Nullable<decimal> NurseOtherPerfor2 { get; set; }
    
        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> NurseExtra { get; set; }
    
        /// <summary>
        /// 考核对分率
        /// </summary>
        public Nullable<decimal> NurseScoringAverage { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> NurseAdjustFactor { get; set; }
    }
}
