﻿using System;
using System.IO;
using System.Net;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;
using System.Text;

namespace Performance.Infrastructure
{
    public class HttpHelper
    {
        #region 发送post请求

        /// <summary>
        /// 发送post请求
        /// </summary>
        /// <param name="Url"></param>
        /// <param name="postDataStr"></param>
        /// <returns></returns>
        public static string HttpPost(string Url, string postDataStr, string encoding = "utf-8", bool IsJson = false)
        {
            HttpWebResponse response = null;
            HttpWebRequest request = null;
            string retString = "";

            if (Url.ToLower().StartsWith("https"))
                ServicePointManager.ServerCertificateValidationCallback = new RemoteCertificateValidationCallback(CheckValidationResult);//验证服务器证书回调自动验证

            try
            {
                //ServicePointManager.SecurityProtocol = SecurityProtocolType.Ssl3;
                System.GC.Collect();
                request = (HttpWebRequest)WebRequest.Create(Url);
                request.Method = "POST";
                request.KeepAlive = false;
                request.ProtocolVersion = HttpVersion.Version10;
                if (IsJson)
                    request.ContentType = "application/json";
                else
                    request.ContentType = "application/x-www-form-urlencoded";
                byte[] bData = (Encoding.UTF8.GetBytes(postDataStr));
                request.ContentLength = bData.Length;
                Stream writeStream = request.GetRequestStream();
                writeStream.Write(bData, 0, bData.Length);
                writeStream.Close();

                using (response = (HttpWebResponse)request.GetResponse())
                {
                    Stream myResponseStream = response.GetResponseStream();
                    StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.GetEncoding(encoding));
                    retString = myStreamReader.ReadToEnd();
                    myStreamReader.Close();
                    myResponseStream.Close();

                    return retString;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                if (request != null)
                    request.Abort();
                if (response != null)
                    response.Close();
            }
        }

        #endregion 发送post请求

        public static string HttpPost(string Url, string postDataStr, bool IsJson)
        {
            return HttpPost(Url, postDataStr, "utf-8", IsJson);
        }

        #region 发送get请求

        /// <summary>
        /// 发送get请求
        /// </summary>
        /// <param name="Url"></param>
        /// <param name="postDataStr"></param>
        /// <returns></returns>
        public static string HttpGet(string Url, string postDataStr, string encoding = "utf-8")
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(Url + (postDataStr == "" ? "" : "?") + postDataStr);
            request.Method = "GET";
            request.ContentType = "text/html;charset=UTF-8";

            HttpWebResponse response = (HttpWebResponse)request.GetResponse();
            Stream myResponseStream = response.GetResponseStream();
            StreamReader myStreamReader = new StreamReader(myResponseStream, Encoding.GetEncoding(encoding));
            string retString = myStreamReader.ReadToEnd();
            myStreamReader.Close();
            myResponseStream.Close();

            return retString;
        }

        #endregion 发送get请求

        public static bool CheckValidationResult(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors errors)
        {   // 总是接受
            return true;
        }
        
    }
}