﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class ComputeService : IAutoInjection
    {
        private readonly PerforResaccountdoctorRepository _perforResAccountdoctorRepository;
        private readonly PerforResaccountnurseRepository _perforResAccountnurseRepository;
        private readonly PerforPersheetRepository _perforPerSheetRepository;
        private readonly PerforImdataRepository _perforImDataRepository;
        private readonly PerforRescomputeRepository _perforRescomputeRepository;
        private readonly PerforResspecialunitRepository _perforResspecialunitRepository;
        private readonly PerforPeragainallotRepository _perforPeragainallotRepository;
        private readonly PerforUserRepository _perforUserRepository;
        private readonly PerforAgemployeeRepository _perforAgemployeeRepository;
        private readonly PerforResbaiscnormRepository perforResbaiscnormRepository;

        public ComputeService(PerforResaccountdoctorRepository perforResAccountdoctorRepository,
            PerforResaccountnurseRepository perforResAccountnurseRepository,
            PerforPersheetRepository perforPerSheetRepository,
            PerforImdataRepository perforImDataRepository,
            PerforRescomputeRepository perforRescomputeRepository,
            PerforResspecialunitRepository perforResspecialunitRepository,
            PerforPeragainallotRepository perforPeragainallotRepository,
            PerforUserRepository perforUserRepository,
            PerforAgemployeeRepository perforAgemployeeRepository,
            PerforResbaiscnormRepository perforResbaiscnormRepository)
        {
            this._perforResAccountdoctorRepository = perforResAccountdoctorRepository;
            this._perforResAccountnurseRepository = perforResAccountnurseRepository;
            this._perforPerSheetRepository = perforPerSheetRepository;
            this._perforImDataRepository = perforImDataRepository;
            this._perforRescomputeRepository = perforRescomputeRepository;
            this._perforResspecialunitRepository = perforResspecialunitRepository;
            this._perforPeragainallotRepository = perforPeragainallotRepository;
            this._perforUserRepository = perforUserRepository;
            this._perforAgemployeeRepository = perforAgemployeeRepository;
            this.perforResbaiscnormRepository = perforResbaiscnormRepository;
        }

        /// <summary>
        /// 返回绩效发放列表
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <param name="type">绩效基数核算参考对象</param>
        /// <returns></returns>
        public List<ResComputeResponse> GetCompute(int allotId, int type)
        {
            var data = new List<ResComputeResponse>();
            List<res_compute> conpute = new List<res_compute>();

            if ((new int[] { 1, 2, 3 }).Contains(type))
            {
                var keyValues2 = new[]
                {
                    new { type = 1, accounttype = AccountUnitType.行政高层 },
                    new { type = 2, accounttype = AccountUnitType.行政中层 },
                    new { type = 3, accounttype = AccountUnitType.行政工勤 },
                };
                var obj = keyValues2.First(t => t.type == type);
                conpute = _perforRescomputeRepository.GetEntities(t => t.AllotID == allotId && t.AccountType == obj.accounttype.ToString())
                    ?.OrderByDescending(t => t.RealGiveFee).ThenBy(t => t.FitPeople).ThenBy(t => t.AccountingUnit).ToList();
            }
            else if ((new int[] { 4, 5 }).Contains(type))
            {
                var types = new PerforType[] { PerforType.临床主任, PerforType.临床副主任, PerforType.医技主任, PerforType.医技副主任 };
                var keyValues2 = new[]
                {
                    new { type = 4, accounttype = types.Select(t=>EnumHelper.GetDescription(t)).ToList() },
                    new { type = 5, accounttype = new List<string>{ EnumHelper.GetDescription(PerforType.护士长) }},
                };
                var obj = keyValues2.First(t => t.type == type);
                var dept = new string[] { AccountUnitType.临床科室.ToString(), AccountUnitType.医技科室.ToString() };
                conpute = _perforRescomputeRepository
                    .GetEntities(t => t.AllotID == allotId && dept.Contains(t.AccountType) && obj.accounttype.Contains(t.FitPeople))
                    ?.OrderByDescending(t => t.RealGiveFee).ThenBy(t => t.FitPeople).ThenBy(t => t.AccountingUnit).ToList();
            }
            else
            {
                throw new PerformanceException("参数错误，type无效");
            }
            data = Mapper.Map<List<ResComputeResponse>>(conpute);
            data?.ForEach(t => t.WorkTime = string.IsNullOrEmpty(t.WorkTime) ? null : Convert.ToDateTime(t.WorkTime).ToString("yyyy-MM-dd"));
            return data;
        }

        /// <summary>
        /// 返回特殊科室发放列表
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<res_specialunit> GetSpecial(int allotId)
        {
            var list = _perforResspecialunitRepository.GetEntities(t => t.AllotID == allotId);
            if (list != null && list.Any())
            {
                list = list.OrderByDescending(t => t.RealGiveFee).ThenBy(t => t.AccountingUnit).ToList();
                return Mapper.Map<List<res_specialunit>>(list);
            }
            return new List<res_specialunit>();
        }

        /// <summary>
        /// 返回医生组科室绩效
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<DoctorResponse> GetDoctorPerformance(int allotId)
        {
            var list = _perforResAccountdoctorRepository.GetEntities(t => t.AllotID == allotId);
            List<DoctorResponse> doctor = Mapper.Map<List<DoctorResponse>>(list);
            doctor?.ForEach(t => t.UnitName = "医生组");
            return doctor;
        }

        /// <summary>
        /// 返回护理组科室绩效
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<NurseResponse> GetNursePerformance(int allotId)
        {
            var list = _perforResAccountnurseRepository.GetEntities(t => t.AllotID == allotId);
            List<NurseResponse> nurse = Mapper.Map<List<NurseResponse>>(list);
            nurse?.ForEach(t => t.UnitName = "护理组");
            return nurse;
        }

        /// <summary>
        /// 查看科室绩效
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="department"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public DeptDetailResponse GetDepartmentDetail(int allotId, string department, int type)
        {
            if (type == 1)
            {
                var accountList = _perforResAccountdoctorRepository.GetEntities(t => t.AllotID == allotId && t.AccountingUnit == department);
                if (accountList != null)
                    return GetDepartmentDetail(allotId, accountList.First().ID, type);
            }
            else if (type == 2)
            {
                var accountList = _perforResAccountnurseRepository.GetEntities(t => t.AllotID == allotId && t.AccountingUnit == department);
                if (accountList != null)
                    return GetDepartmentDetail(allotId, accountList.First().ID, type);
            }
            return null;
        }


        /// <summary>
        /// 返回科室详情
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="accountId"></param>
        /// <param name="type"> 1 医生组 2 护理组</param>
        /// <returns></returns>
        public DeptDetailResponse GetDepartmentDetail(int allotId, int accountId, int type)
        {
            var sheetList = _perforPerSheetRepository.GetEntities(t => t.AllotID == allotId);
            if (type == 1)
            {
                var doctor = _perforResAccountdoctorRepository.GetEntity(t => t.AllotID == allotId && t.ID == accountId);

                DeptDetailResponse response = new DeptDetailResponse()
                {
                    Pandect = Mapper.Map<PerDataAccount>(doctor),
                    Economic = new List<DeptDetail>(),
                    Workload = new List<DeptDetail>()
                };

                var sheetWorkload = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeDoctorWorkload);
                if (sheetWorkload == null)
                    return null;
                var dataWorkloadList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetWorkload.ID && t.IsTotal != 1 && t.AccountingUnit == doctor.AccountingUnit);
                if (dataWorkloadList != null && dataWorkloadList.Count > 0)
                    dataWorkloadList.ForEach(t => response.Workload.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));

                var sheetEconomic = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeEconomic);
                if (sheetEconomic == null)
                    return null;
                var dataEconomicList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetEconomic.ID && t.UnitType == 1 && t.IsTotal != 1 && t.AccountingUnit == doctor.AccountingUnit);
                if (dataEconomicList != null && dataEconomicList.Count > 0)
                    dataEconomicList.ForEach(t => response.Economic.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));

                return response;
            }
            else if (type == 2)
            {
                var nurse = _perforResAccountnurseRepository.GetEntity(t => t.AllotID == allotId && t.ID == accountId);
                DeptDetailResponse response = new DeptDetailResponse()
                {
                    Pandect = Mapper.Map<PerDataAccount>(nurse),
                    Economic = new List<DeptDetail>(),
                    Workload = new List<DeptDetail>()
                };

                var sheetWorkload = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeNurseWorkload);
                if (sheetWorkload == null)
                    return null;
                var dataWorkloadList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetWorkload.ID && t.IsTotal != 1 && t.AccountingUnit == nurse.AccountingUnit);
                if (dataWorkloadList != null && dataWorkloadList.Count > 0)
                    dataWorkloadList.ForEach(t => response.Workload.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));

                var sheetEconomic = sheetList.FirstOrDefault(t => t.SheetType == (int)SheetType.ComputeEconomic);
                if (sheetEconomic == null)
                    return null;
                var dataEconomicList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetEconomic.ID && t.UnitType == 2 && t.IsTotal != 1 && t.AccountingUnit == nurse.AccountingUnit);
                if (dataEconomicList != null && dataEconomicList.Count > 0)
                    dataEconomicList.ForEach(t => response.Economic.Add(new DeptDetail { ItemName = t.TypeName, ItemValue = t.CellValue ?? 0 }));
                return response;
            }

            return null;
        }

        /// <summary>
        /// 返回绩效发放列表
        /// </summary>
        /// <param name="allotId">绩效ID</param>
        /// <returns></returns>
        public List<ComputeResponse> AllCompute(int allotId)
        {
            var list = new List<ComputeResponse>();
            var allot = _perforRescomputeRepository.GetEntities(t => t.AllotID == allotId);
            list = Mapper.Map<List<ComputeResponse>>(allot);
            list?.ForEach(t => t.Source = "一次绩效");
            var employee = _perforAgemployeeRepository.GetEntities(t => t.AllotID == allotId);
            if (employee != null && employee.Count > 0)
            {
                var again = _perforPeragainallotRepository.GetEntities(t => employee.Select(e => e.AgainAllotID).Contains(t.ID));
                if (again != null)
                {
                    var data = _perforUserRepository.GetEntities(t => again.Select(a => a.CreateUser).Contains(t.ID) && t.States == 1);
                    var list1 = from e in employee
                                join a in again on e.AgainAllotID equals a.ID
                                join user in data on a.CreateUser equals user.ID
                                select new ComputeResponse
                                {
                                    Source = "二次绩效",
                                    AccountingUnit = a.Department,
                                    EmployeeName = user.RealName,
                                    JobTitle = e.JobTitle,
                                    RealGiveFee = e.RealGiveFee
                                };
                    list = list.Union(list1.OrderBy(t => t.AccountingUnit)).ToList();
                }
            }
            return list;
        }

        public res_compute GetComputeSingle(int computeid)
        {
            return _perforRescomputeRepository.GetEntity(t => t.ID == computeid);
        }

        /// <summary>
        /// 修改实发绩效
        /// </summary>
        /// <param name="type"></param>
        /// <param name="id"></param>
        /// <param name="score"></param>
        /// <returns></returns>
        public res_compute UpdateRealfee(ComputerRequest request, UserIdentity user)
        {
            var compute = _perforRescomputeRepository.GetEntity(t => t.ID == request.ComputeId);
            var log = JsonHelper.Deserialize<List<ChangeLog>>(compute.ChangeLog);
            log = log ?? new List<ChangeLog>();
            log.Add(new ChangeLog
            {
                uid = user.UserID,
                user = user.RealName,
                date = DateTime.Now,
                value = compute.RealGiveFee
            });
            compute.RealGiveFee = request.RealGiveFee;
            compute.ChangeLog = JsonHelper.Serialize(log);
            if (!_perforRescomputeRepository.Update(compute))
                throw new PerformanceException("修改失败");

            return compute;
        }

        /// <summary>
        /// 返回绩效平均值
        /// </summary>
        /// <param name="type"></param>
        /// <param name="id"></param>
        /// <param name="score"></param>
        /// <returns></returns>
        public List<res_baiscnorm> GetBaiscnorm(int allotId)
        {
            return perforResbaiscnormRepository.GetEntities(t => t.AllotID == allotId);
        }
    }
}
