﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 收入
    /// </summary>
    public class PerSheetDataReadIncome : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 3,
            HeaderLastRowNum = 3,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 4,
            AccountingUnit = new List<AccountingUnit>
            {
                //核算单元（医生组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 0,
                    UnitType = "医生组",
                    DeptCellNum = 2,
                    FactorRow = 2,
                },
                //核算单元（护理组）
                new AccountingUnit
                {
                    AccountingUnitCellNum = 1,
                    UnitType = "护理组",
                    DeptCellNum = 2,
                    FactorRow = 1,
                }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            //循环 当前有几个核算单元
            foreach (var unit in Point.AccountingUnit)
            {
                //查询除了 核算单元  科室名称 有效数据列头位置
                var vhead = perHeader.Where(t => !Point.AccountingUnit.Select(p => p.AccountingUnitCellNum).Contains(t.PointCell)
                    && !Point.AccountingUnit.Select(p => p.DeptCellNum).Contains(t.PointCell)).OrderBy(t => t.PointCell);
                for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
                {
                    var row = sheet.GetRow(r);
                    if (row == null) continue;

                    for (int c = 0; c < vhead.Count(); c++)
                    {
                        var athead = vhead.ElementAt(c);
                        var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                        if (!cellValue.HasValue || cellValue.Value == 0)
                            continue;
                        PerData data = new PerData
                        {
                            RowNumber = r,
                            SignID = athead.SignID,
                            AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value)?.ToString(),
                            Department = row.GetCell(unit.DeptCellNum.Value)?.ToString(),
                            TypeName = athead?.CellValue,
                            CellValue = cellValue,
                            Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                            UnitType = unit.UnitType, //手动匹配
                            FactorValue = ConvertHelper.To<decimal?>(sheet.GetRow(unit.FactorRow.Value).GetCell(athead.PointCell)?.ToString()),
                            IsFactor = true,
                        };
                        dataList.Add(data);
                    }
                }
            }
            return dataList;
        }
    }
}
