﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// 查看科室绩效详情
    /// </summary>
    public class DeptDetailRequest
    {
        /// <summary>
        /// 绩效id
        /// </summary>
        public int AllotId { get; set; }

        /// <summary>
        /// 绩效类型（1 医生组、 2 护理组）
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 汇总ID
        /// </summary>
        public int AccountID { get; set; }
    }
    public class DetailRequestValidator : AbstractValidator<DeptDetailRequest>
    {
        public DetailRequestValidator()
        {
            RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
            RuleFor(x => x.Type).NotNull().InclusiveBetween(1, 5);
            RuleFor(x => x.AccountID).NotNull().GreaterThan(0);
        }
    }
}
