
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using System;

namespace Performance.EntityModels
{
    public partial class PerformanceDbContext : DbContext
    {
        public PerformanceDbContext(DbContextOptions<PerformanceDbContext> options)
            : base(options)
        {
        }

		/// <summary> 二次分配概览 </summary>
        public virtual DbSet<ag_againsituation> ag_againsituation { get; set; }
		/// <summary> 二次绩效结果表 </summary>
        public virtual DbSet<ag_compute> ag_compute { get; set; }
		/// <summary> 二次分配不固定数据 </summary>
        public virtual DbSet<ag_data> ag_data { get; set; }
		/// <summary> 二次分配人员名单 </summary>
        public virtual DbSet<ag_employee> ag_employee { get; set; }
		/// <summary> 二次绩效固定项 </summary>
        public virtual DbSet<ag_fixatitem> ag_fixatitem { get; set; }
		/// <summary> 二次分配不固定列头数据 </summary>
        public virtual DbSet<ag_header> ag_header { get; set; }
		/// <summary> 科室二次绩效录入内容 </summary>
        public virtual DbSet<ag_itemvalue> ag_itemvalue { get; set; }
		/// <summary> 二次绩效列表 </summary>
        public virtual DbSet<ag_secondallot> ag_secondallot { get; set; }
		/// <summary> 二次绩效模板 </summary>
        public virtual DbSet<ag_temp> ag_temp { get; set; }
		/// <summary> 二次绩效模板项 </summary>
        public virtual DbSet<ag_tempitem> ag_tempitem { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<ag_usetemp> ag_usetemp { get; set; }
		/// <summary> 二次绩效工作量绩效 </summary>
        public virtual DbSet<ag_workload> ag_workload { get; set; }
		/// <summary> 考核类别 </summary>
        public virtual DbSet<as_assess> as_assess { get; set; }
		/// <summary> 考核列头 </summary>
        public virtual DbSet<as_columns> as_columns { get; set; }
		/// <summary> 考核数据 </summary>
        public virtual DbSet<as_data> as_data { get; set; }
		/// <summary> 考核类别 </summary>
        public virtual DbSet<as_tempassess> as_tempassess { get; set; }
		/// <summary> 考核列头 </summary>
        public virtual DbSet<as_tempcolumns> as_tempcolumns { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<cof_again> cof_again { get; set; }
		/// <summary> 上传excel文件校验配置 </summary>
        public virtual DbSet<cof_check> cof_check { get; set; }
		/// <summary> 规模绩效、效率绩效计算系数配置 </summary>
        public virtual DbSet<cof_director> cof_director { get; set; }
		/// <summary> 工作量门诊药占比系数 </summary>
        public virtual DbSet<cof_drugprop> cof_drugprop { get; set; }
		/// <summary> 药占比费用列头名称 </summary>
        public virtual DbSet<cof_drugtype> cof_drugtype { get; set; }
		/// <summary> 保底科室配置 </summary>
        public virtual DbSet<cof_guarantee> cof_guarantee { get; set; }
		/// <summary> ICU医生护士有效收入汇总计算系数 </summary>
        public virtual DbSet<cof_income> cof_income { get; set; }
		/// <summary> 特殊绩效项指标 </summary>
        public virtual DbSet<cof_singlefactor> cof_singlefactor { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<cof_workitem> cof_workitem { get; set; }
		/// <summary> 工龄对应绩效系数配置 </summary>
        public virtual DbSet<cof_workyear> cof_workyear { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<hos_personfee> hos_personfee { get; set; }
		/// <summary> 科室核算导入信息 </summary>
        public virtual DbSet<im_accountbasic> im_accountbasic { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_data> im_data { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_employee> im_employee { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<im_header> im_header { get; set; }
		/// <summary> 特殊科室核算 </summary>
        public virtual DbSet<im_specialunit> im_specialunit { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<log_check> log_check { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<log_dbug> log_dbug { get; set; }
		/// <summary> 医院数据提取脚本 </summary>
        public virtual DbSet<mod_extract> mod_extract { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<mod_item> mod_item { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<mod_module> mod_module { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<mod_special> mod_special { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<per_againallot> per_againallot { get; set; }
		/// <summary> 医院绩效分配 </summary>
        public virtual DbSet<per_allot> per_allot { get; set; }
		/// <summary> 首次上传文件地址（当医院存在标准库时，首次上传用户提交固定格式的excel，开发人员配置SQL脚本） </summary>
        public virtual DbSet<per_first> per_first { get; set; }
		/// <summary> 上传数据解析 </summary>
        public virtual DbSet<per_sheet> per_sheet { get; set; }
		/// <summary> 科室核算结果 </summary>
        public virtual DbSet<res_account> res_account { get; set; }
		/// <summary> 医生科室核算结果 </summary>
        public virtual DbSet<res_accountdoctor> res_accountdoctor { get; set; }
		/// <summary> 护理科室核算结果 </summary>
        public virtual DbSet<res_accountnurse> res_accountnurse { get; set; }
		/// <summary> 核算基础标准 </summary>
        public virtual DbSet<res_baiscnorm> res_baiscnorm { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<res_compute> res_compute { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<res_specialunit> res_specialunit { get; set; }
		/// <summary> 医院数据提取脚本 </summary>
        public virtual DbSet<sys_extract> sys_extract { get; set; }
		/// <summary> 医院信息 </summary>
        public virtual DbSet<sys_hospital> sys_hospital { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_hospitalconfig> sys_hospitalconfig { get; set; }
		/// <summary> 菜单表 </summary>
        public virtual DbSet<sys_menu> sys_menu { get; set; }
		/// <summary> 角色表 </summary>
        public virtual DbSet<sys_role> sys_role { get; set; }
		/// <summary> 角色菜单关联表 </summary>
        public virtual DbSet<sys_role_menu> sys_role_menu { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_sms> sys_sms { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_task> sys_task { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_user> sys_user { get; set; }
		/// <summary>  </summary>
        public virtual DbSet<sys_user_hospital> sys_user_hospital { get; set; }
		/// <summary> 用户角色关联表 </summary>
        public virtual DbSet<sys_user_role> sys_user_role { get; set; }
    }
}
