﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class HospitalController : Controller
    {
        private HospitalService _hospitalService;
        private ClaimService _claim;
        public HospitalController(HospitalService hospitalService, ClaimService claimService)
        {
            _hospitalService = hospitalService;
            _claim = claimService;
        }

        /// <summary>
        /// 获取当前登录用户管辖医院列表
        /// </summary>
        /// <returns></returns>
        [Route("hospitallist")]
        [HttpPost]
        public ApiResponse<List<HospitalResponse>> GetHospitalList()
        {
            var hospitalList = _hospitalService.GetUserHopital(_claim.GetUserId());
            return new ApiResponse<List<HospitalResponse>>(ResponseType.OK, "ok", hospitalList);
        }

        /// <summary>
        /// 新增医院
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("insert")]
        [HttpPost]
        public ApiResponse<HospitalResponse> Insert([CustomizeValidator(RuleSet = "Insert"), FromBody]HospitalRequest request)
        {
            var userid = _claim.GetUserId();
            var hospital = _hospitalService.Insert(request, userid);
            _hospitalService.InsertUserHospital(userid, hospital.HosID);
            return new ApiResponse<HospitalResponse>(ResponseType.OK, hospital);
        }

        /// <summary>
        /// 修改医院信息
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("update")]
        [HttpPost]
        public ApiResponse<HospitalResponse> Update([CustomizeValidator(RuleSet = "Update"), FromBody]HospitalRequest request)
        {
            var hospital = _hospitalService.Update(request);
            return new ApiResponse<HospitalResponse>(ResponseType.OK, hospital);
        }

        /// <summary>
        /// 删除医院
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [ApiDisable]
        [Route("delete")]
        [HttpPost]
        public ApiResponse Delete([CustomizeValidator(RuleSet = "Delete"), FromBody]HospitalRequest request)
        {
            if (!_hospitalService.Delete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }

        /// <summary>
        /// 启用/禁用医院
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("disabled")]
        [HttpPost]
        public ApiResponse Disabled([CustomizeValidator(RuleSet = "Disable"), FromBody]HospitalRequest request)
        {
            if (!_hospitalService.Disabled(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
    }
}
