﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// sheet页列表请求
    /// </summary>
    public class SheetRequest
    {
        public int AllotID { get; set; }

        public int Source { get; set; }

    }
    public class SheetRequestValidator : AbstractValidator<SheetRequest>
    {
        public SheetRequestValidator()
        {
            RuleFor(x => x.AllotID).NotNull().GreaterThan(0);
            RuleFor(x => x.Source).NotNull().InclusiveBetween(1, 2);
        }
    }
}
