﻿using Performance.DtoModels;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class BaiscNormService : IAutoInjection
    {
        public decimal? GetBaiscNorm(List<res_baiscnorm> baiscnorms, PerformanceType type)
        {
            decimal? result = null; 
            if (type == PerformanceType.ReferenceDirector)
            {
                result = baiscnorms.FirstOrDefault(t => t.PositionName == "临床科主任")?.AvgValue;
            }
            else if (type == PerformanceType.ReferenceDirectorAvg)
            {
                List<string> avgObjectList = new List<string> { "临床科主任", "临床科副主任", "医技科主任", "临床科护长" };
                var baisc = baiscnorms.Where(t => avgObjectList.Contains(t.PositionName));

                result = baisc.Sum(s => s.TotelValue) / baisc.Sum(s => s.TotelNumber);
            }
            else if (type == PerformanceType.ReferenceHeadNurse)
            {
                result = baiscnorms.FirstOrDefault(t => t.PositionName == "临床科护长")?.AvgValue;
            }
            else if (type == PerformanceType.ReferenceNurseAvg95)
            {
                result = baiscnorms.FirstOrDefault(t => t.PositionName == "临床护士")?.AvgValue * 0.95m;
            }
            if (result.HasValue)
                result = Math.Round(result.Value, 4);
            return result;
        }
    }
}
